/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.core.publisher.is.legacy.container;

import com.sun.management.OperatingSystemMXBean;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.management.ManagementFactory;
import java.math.BigDecimal;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gcube.common.core.publisher.is.legacy.container.LinuxDistributionInfo;
import org.gcube.common.resources.gcore.HostingNode;
import org.gcube.common.resources.gcore.utils.Group;
import org.gcube.smartgears.configuration.container.ContainerConfiguration;
import org.gcube.smartgears.configuration.library.SmartGearsConfiguration;
import org.gcube.smartgears.context.container.ContainerContext;
import org.gcube.smartgears.lifecycle.container.ContainerState;
import org.gcube.smartgears.provider.ProviderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContainerProfileBuilder {
    private static Logger log = LoggerFactory.getLogger(ContainerProfileBuilder.class);
    private ContainerContext context;

    public ContainerProfileBuilder(ContainerContext context) {
        this.context = context;
    }

    public HostingNode create() {
        HostingNode node = new HostingNode();
        ContainerConfiguration cfg = this.context.configuration();
        node.newProfile().infrastructure(cfg.infrastructure());
        node.setId(this.context.id());
        this.addSiteTo(node);
        String ip = "not resolved";
        try {
            ip = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            log.warn("unable to detect the IP address of the host");
        }
        node.profile().newDescription().activationTime(Calendar.getInstance()).name(cfg.hostname() + ":" + cfg.port());
        ((HostingNode.Profile.NodeDescription.NetworkAdapter)node.profile().description().networkAdapters().add()).mtu(0).name("local-adapter").ipAddress(ip).inboundIP("").outboundIP("");
        node.profile().description().newOperatingSystem().name(System.getProperty("os.name")).version(System.getProperty("os.version")).release("");
        node.profile().description().newArchitecture().platformType(System.getProperty("os.arch")).smpSize(0).smtSize(0);
        node.profile().newSite().domain(cfg.site().getCountry()).country(cfg.site().getCountry()).location(cfg.site().getLocation()).latitude("1").longitude("1");
        ArrayList<HashMap<String, String>> info = this.cpuInfo();
        Group processors = node.profile().description().processors();
        for (HashMap<String, String> map : info) {
            ((HostingNode.Profile.NodeDescription.Processor)processors.add()).bogomips(new BigDecimal(map.get("bogomips"))).clockSpeedMhz(new BigDecimal(map.get("cpu_MHz"))).family(map.get("cpu_family")).modelName(map.get("model_name")).model(map.get("model")).vendor(map.get("vendor_id")).cacheL1(new Integer(map.get("cache_size")).intValue()).cacheL1D(0).cacheL1I(0).cacheL2(0);
        }
        this.addVariablesTo(node);
        this.update(node, false);
        node.profile().description().type(HostingNode.Profile.NodeDescription.GHNType.Static);
        ((HostingNode.Profile.NodeDescription.LocalFileSystem)node.profile().description().localFileSystems().add()).name("").type("").readOnly(false).root("/");
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<HashMap<String, String>> cpuInfo() {
        ArrayList<HashMap<String, String>> map = new ArrayList<HashMap<String, String>>();
        File file = new File("/proc/cpuinfo");
        if (!file.exists()) {
            log.warn("cannot acquire CPU info (no /proc/cpuinfo)");
            return map;
        }
        BufferedReader input = null;
        try {
            input = new BufferedReader(new FileReader(file));
            String line = null;
            HashMap<String, String> currentProcessor = null;
            while ((line = input.readLine()) != null) {
                if (line.startsWith("processor")) {
                    if (currentProcessor != null) {
                        map.add((HashMap)currentProcessor.clone());
                    }
                    currentProcessor = new HashMap<String, String>();
                }
                try {
                    if (line.contains("vendor_id")) {
                        currentProcessor.put("vendor_id", line.split(":")[1].trim());
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (line.contains("cpu family")) {
                        currentProcessor.put("cpu_family", line.split(":")[1].trim());
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (line.contains("model\t") || line.contains("model\b")) {
                        currentProcessor.put("model", line.split(":")[1].trim());
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (line.contains("model name")) {
                        currentProcessor.put("model_name", line.split(":")[1].trim());
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (line.contains("cpu MHz")) {
                        currentProcessor.put("cpu_MHz", line.split(":")[1].trim());
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (line.contains("cache size")) {
                        currentProcessor.put("cache_size", line.split(":")[1].trim().split(" ")[0]);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (!line.contains("bogomips")) continue;
                    currentProcessor.put("bogomips", line.split(":")[1].trim());
                }
                catch (Exception exception) {}
            }
            if (currentProcessor != null) {
                map.add(currentProcessor);
            }
        }
        catch (Exception e) {
            log.warn("unable to acquire CPU info", (Throwable)e);
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException e) {
                    log.warn("unable to close stream", (Throwable)e);
                }
            }
        }
        return map;
    }

    private long getFreeSpace() {
        long free = 0L;
        try {
            free = this.context.configuration().persistence().getFreeSpace() / 1024L;
        }
        catch (Exception ioe) {
            log.warn("unable to detect the free space on the disk", (Throwable)ioe);
        }
        return free;
    }

    public void update(HostingNode node, boolean onLoad) {
        ContainerConfiguration cfg = this.context.configuration();
        if (onLoad) {
            log.info("updating ghn profile");
            node.profile().description().activationTime(Calendar.getInstance()).name(cfg.hostname() + ":" + cfg.port());
            this.addVariablesTo(node);
            this.addSiteTo(node);
        }
        node.profile().description().status(((ContainerState)this.context.lifecycle().state()).remoteForm());
        Map<String, Long> mem = this.memoryUsage();
        node.profile().description().newMainMemory().ramAvailable(mem.get("MemoryAvailable").longValue()).ramSize(mem.get("MemoryTotalSize").longValue()).virtualAvailable(mem.get("VirtualAvailable").longValue()).virtualSize(mem.get("VirtualSize").longValue());
        node.profile().description().localAvailableSpace(Long.valueOf(this.getFreeSpace()));
        node.profile().description().uptime(this.uptime());
        node.profile().description().lastUpdate(Calendar.getInstance());
        Map<String, Double> loads = this.loadStatistics();
        node.profile().description().newLoad().lastMin(loads.get("1min") == null ? 0.0 : loads.get("1min")).last5Mins(loads.get("5mins") == null ? 0.0 : loads.get("5mins")).last15Mins(loads.get("15mins") == null ? 0.0 : loads.get("15mins"));
    }

    private void addSiteTo(HostingNode node) {
        ContainerConfiguration cfg = this.context.configuration();
        node.profile().newSite().country(cfg.site().getCountry()).location(cfg.site().getLocation()).latitude("unknown").longitude("unknown").domain(this.domainIn(cfg.hostname()));
    }

    private void addVariablesTo(HostingNode node) {
        ContainerConfiguration cfg = this.context.configuration();
        Group variables = node.profile().description().environmentVariables();
        variables.removeAll((Collection)node.profile().description().environmentVariables());
        HashMap<String, String> map = new HashMap<String, String>();
        map.putAll(cfg.properties());
        map.putAll(System.getenv());
        for (Map.Entry entry : map.entrySet()) {
            String varname = (String)entry.getKey();
            if (varname.compareToIgnoreCase("CLASSPATH") == 0 || varname.compareToIgnoreCase("PATH") == 0 || varname.contains("SSH") || varname.contains("MAIL") || varname.compareToIgnoreCase("LS_COLORS") == 0) continue;
            ((HostingNode.Profile.NodeDescription.Variable)variables.add()).keyAndValue((String)entry.getKey(), (String)entry.getValue());
        }
        String osVersion = System.getProperty("os.name");
        if (osVersion.compareToIgnoreCase("Linux") == 0) {
            LinuxDistributionInfo linuxDistributionInfo = new LinuxDistributionInfo();
            Map<String, String> info = linuxDistributionInfo.getInfo();
            for (String key : info.keySet()) {
                ((HostingNode.Profile.NodeDescription.Variable)variables.add()).keyAndValue(key, info.get(key));
            }
        }
        ((HostingNode.Profile.NodeDescription.Variable)variables.add()).keyAndValue("Java", System.getProperty("java.version"));
        SmartGearsConfiguration config = ProviderFactory.provider().smartgearsConfiguration();
        ((HostingNode.Profile.NodeDescription.Variable)variables.add()).keyAndValue("SmartGears", config.version());
        ((HostingNode.Profile.NodeDescription.Variable)variables.add()).keyAndValue("ghn-update-interval-in-secs", String.valueOf(cfg.publicationFrequency()));
    }

    public String uptime() {
        String lines = "";
        String linetemp = null;
        try {
            Process p = Runtime.getRuntime().exec("uptime");
            p.waitFor();
            BufferedReader input = new BufferedReader(new InputStreamReader(p.getInputStream()));
            while ((linetemp = input.readLine()) != null) {
                lines = lines + linetemp;
            }
            input.close();
            p.destroy();
            lines = lines.split(",")[0].split("up")[1].trim();
        }
        catch (Exception e) {
            log.warn("unable to detect the uptime of this machine", (Throwable)e);
            lines = "unable to detect";
        }
        return lines;
    }

    public Map<String, Double> loadStatistics() {
        HashMap<String, Double> result = new HashMap<String, Double>();
        try {
            File loadadv = new File("/proc/loadavg");
            if (loadadv.exists()) {
                int c;
                FileReader reader = new FileReader(loadadv);
                StringBuilder content = new StringBuilder();
                while ((c = ((Reader)reader).read()) != -1) {
                    content.append((char)c);
                }
                ((Reader)reader).close();
                Pattern p = Pattern.compile("^(.*?)\\s{1}(.*?)\\s{1}(.*?)\\s{1}(.*)$");
                Matcher matcher = p.matcher(content.toString());
                if (matcher.matches() && matcher.groupCount() > 3) {
                    result.put("1min", new Double(matcher.group(1)));
                    result.put("5mins", new Double(matcher.group(2)));
                    result.put("15mins", new Double(matcher.group(3).split("\\s")[0]));
                }
            }
        }
        catch (Exception ioe) {
            log.warn("unable to detect the load values of this machine", (Throwable)ioe);
        }
        return result;
    }

    public Map<String, Long> memoryUsage() {
        HashMap<String, Long> map = new HashMap<String, Long>();
        java.lang.management.OperatingSystemMXBean mxbean = ManagementFactory.getOperatingSystemMXBean();
        OperatingSystemMXBean sunmxbean = (OperatingSystemMXBean)mxbean;
        long freeMemory = sunmxbean.getFreePhysicalMemorySize() / 0x100000L;
        long availableMemory = sunmxbean.getTotalPhysicalMemorySize() / 0x100000L;
        map.put("MemoryAvailable", freeMemory);
        map.put("MemoryTotalSize", availableMemory);
        long ramVirtualAvailable = Runtime.getRuntime().freeMemory() / 0x100000L;
        long ramVirtualSize = Runtime.getRuntime().totalMemory() / 0x100000L;
        map.put("VirtualAvailable", ramVirtualAvailable);
        map.put("VirtualSize", ramVirtualSize);
        return map;
    }

    private String domainIn(String hostname) {
        Pattern pattern = Pattern.compile("([0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3})");
        Matcher regexMatcher = pattern.matcher(hostname);
        if (regexMatcher.matches()) {
            return hostname;
        }
        String[] tokens = hostname.split("\\.");
        if (tokens.length < 2) {
            return hostname;
        }
        return tokens[tokens.length - 2] + "." + tokens[tokens.length - 1];
    }
}

