/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.core.publisher.is.legacy;

import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.gcube.common.core.publisher.is.legacy.ICSecret;
import org.gcube.common.core.publisher.is.legacy.Registry;
import org.gcube.common.core.publisher.is.legacy.application.ApplicationProfileBuilder;
import org.gcube.common.core.publisher.is.legacy.container.ContainerProfileBuilder;
import org.gcube.common.resources.gcore.GCoreEndpoint;
import org.gcube.common.resources.gcore.HostingNode;
import org.gcube.common.resources.gcore.Resource;
import org.gcube.common.resources.gcore.ResourceMediator;
import org.gcube.common.resources.gcore.Resources;
import org.gcube.common.security.AuthorizedTasks;
import org.gcube.common.security.ContextBean;
import org.gcube.common.security.secrets.Secret;
import org.gcube.smartgears.context.application.ApplicationContext;
import org.gcube.smartgears.context.container.ContainerContext;
import org.gcube.smartgears.publishing.Publisher;
import org.gcube.smartgears.publishing.SmartgearsProfilePublisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SmartgearsProfilePublisher
public class LegacyISPublisher
implements Publisher {
    private static Logger logger = LoggerFactory.getLogger(LegacyISPublisher.class);
    private Registry registry = new Registry();
    private static Map<String, Resource> resourcesCache = new HashMap<String, Resource>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean create(ContainerContext container, Set<String> contexts) {
        HostingNode hostingNode;
        ContainerProfileBuilder cpb = new ContainerProfileBuilder(container);
        Map<String, Resource> map = resourcesCache;
        synchronized (map) {
            String id = container.id();
            if (!resourcesCache.containsKey(id)) {
                hostingNode = cpb.create();
            } else {
                hostingNode = (HostingNode)resourcesCache.get(id);
                cpb.update(hostingNode, false);
            }
            for (String context : contexts) {
                ResourceMediator.setScope((Resource)hostingNode, context);
            }
            resourcesCache.put(id, (Resource)hostingNode);
        }
        for (String context : this.filterICContexts(hostingNode.scopes().asCollection())) {
            try {
                logger.info("publishing container in context {}", (Object)context);
                AuthorizedTasks.executeSafely(() -> {
                    try {
                        this.registry.getStubs().create(this.toXml((Resource)hostingNode), hostingNode.type().toString());
                    }
                    catch (Exception e) {
                        logger.error("error publishing container", (Throwable)e);
                        throw new RuntimeException(e);
                    }
                }, (Secret)new ICSecret(context));
            }
            catch (Throwable e) {
                logger.error("error publishing container in context {}", (Object)context, (Object)e);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean create(ApplicationContext application, Set<String> contexts) {
        GCoreEndpoint endpoint;
        ApplicationProfileBuilder cpb = new ApplicationProfileBuilder(application);
        Map<String, Resource> map = resourcesCache;
        synchronized (map) {
            String id = application.id();
            endpoint = !resourcesCache.containsKey(id) ? cpb.create() : (GCoreEndpoint)resourcesCache.get(id);
            for (String context : contexts) {
                ResourceMediator.setScope((Resource)endpoint, context);
            }
            resourcesCache.put(id, (Resource)endpoint);
        }
        for (String context : this.filterICContexts(endpoint.scopes().asCollection())) {
            try {
                logger.info("publishing application in context {}", (Object)context);
                AuthorizedTasks.executeSafely(() -> {
                    try {
                        String resource = this.toXml((Resource)endpoint);
                        this.registry.getStubs().create(resource, endpoint.type().toString());
                    }
                    catch (Exception e) {
                        logger.error("erro publishing application", (Throwable)e);
                        throw new RuntimeException(e);
                    }
                }, (Secret)new ICSecret(context));
            }
            catch (Throwable e) {
                logger.error("error publishing application profile in context {}", (Object)context, (Object)e);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean remove(ContainerContext container, Set<String> contexts) {
        HostingNode hostingNode;
        ContainerProfileBuilder cpb = new ContainerProfileBuilder(container);
        Iterator<String> iterator = resourcesCache;
        synchronized (iterator) {
            String id = container.id();
            if (!resourcesCache.containsKey(id)) {
                hostingNode = cpb.create();
            } else {
                hostingNode = (HostingNode)resourcesCache.get(id);
                cpb.update(hostingNode, false);
            }
            for (String context : contexts) {
                ResourceMediator.removeScope((Resource)hostingNode, context);
            }
            resourcesCache.put(id, (Resource)hostingNode);
        }
        for (String context : contexts) {
            if (!this.isCompatibleScopeForRemove(hostingNode, context)) continue;
            try {
                AuthorizedTasks.executeSafely(() -> {
                    try {
                        logger.info("removing container from context {}", (Object)context);
                        this.registry.getStubs().remove(hostingNode.id(), hostingNode.type().toString());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }, (Secret)new ICSecret(context));
            }
            catch (Throwable e) {
                logger.error("error removing container in context {}", (Object)context, (Object)e);
            }
        }
        for (String context : this.filterICContexts(hostingNode.scopes().asCollection())) {
            try {
                logger.info("updating container in context {}", (Object)context);
                AuthorizedTasks.executeSafely(() -> {
                    try {
                        this.registry.getStubs().update(hostingNode.id(), hostingNode.type().toString(), this.toXml((Resource)hostingNode));
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }, (Secret)new ICSecret(context));
            }
            catch (Throwable e) {
                logger.error("error updating container in context {}", (Object)context, (Object)e);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean remove(ApplicationContext application, Set<String> contexts) {
        GCoreEndpoint endpoint;
        ApplicationProfileBuilder cpb = new ApplicationProfileBuilder(application);
        Iterator<String> iterator = resourcesCache;
        synchronized (iterator) {
            String id = application.id();
            endpoint = !resourcesCache.containsKey(id) ? cpb.create() : (GCoreEndpoint)resourcesCache.get(id);
            for (String context : contexts) {
                ResourceMediator.removeScope((Resource)endpoint, context);
            }
            resourcesCache.put(id, (Resource)endpoint);
        }
        for (String context : contexts) {
            if (!this.isCompatibleScopeForRemove(endpoint, context)) continue;
            try {
                AuthorizedTasks.executeSafely(() -> {
                    try {
                        logger.info("removing container in context {}", (Object)context);
                        this.registry.getStubs().remove(endpoint.id(), endpoint.type().toString());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }, (Secret)new ICSecret(context));
            }
            catch (Throwable e) {
                logger.error("error removing container in context {}", (Object)context, (Object)e);
            }
        }
        for (String context : this.filterICContexts(endpoint.scopes().asCollection())) {
            try {
                AuthorizedTasks.executeSafely(() -> {
                    try {
                        logger.info("updating application in context {}", (Object)context);
                        String resource = this.toXml((Resource)endpoint);
                        this.registry.getStubs().update(endpoint.id(), endpoint.type().toString(), resource);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }, (Secret)new ICSecret(context));
            }
            catch (Throwable e) {
                logger.error("error updating application profile in context {}", (Object)context, (Object)e);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean update(ApplicationContext application) {
        GCoreEndpoint endpoint;
        Map<String, Resource> map = resourcesCache;
        synchronized (map) {
            String id = application.id();
            endpoint = (GCoreEndpoint)resourcesCache.get(id);
        }
        for (String context : this.filterICContexts(endpoint.scopes().asCollection())) {
            try {
                logger.info("updating application in context {}", (Object)context);
                AuthorizedTasks.executeSafely(() -> {
                    try {
                        String resource = this.toXml((Resource)endpoint);
                        this.registry.getStubs().update(endpoint.id(), endpoint.type().toString(), resource);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }, (Secret)new ICSecret(context));
            }
            catch (Throwable e) {
                logger.error("error updating application profile in context {}", (Object)context, (Object)e);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean update(ContainerContext container) {
        HostingNode hostingNode;
        ContainerProfileBuilder cpb = new ContainerProfileBuilder(container);
        Map<String, Resource> map = resourcesCache;
        synchronized (map) {
            String id = container.id();
            hostingNode = (HostingNode)resourcesCache.get(id);
            cpb.update(hostingNode, false);
            resourcesCache.put(id, (Resource)hostingNode);
        }
        for (String context : this.filterICContexts(hostingNode.scopes().asCollection())) {
            try {
                logger.info("updating container in context {}", (Object)context);
                AuthorizedTasks.executeSafely(() -> {
                    try {
                        logger.info("updating container in context {}", (Object)context);
                        this.registry.getStubs().update(hostingNode.id(), hostingNode.type().toString(), this.toXml((Resource)hostingNode));
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }, (Secret)new ICSecret(context));
            }
            catch (Throwable e) {
                logger.error("error updating container in context {}", (Object)context, (Object)e);
            }
        }
        return true;
    }

    private String toXml(Resource resource) {
        StringWriter writer = new StringWriter();
        Resources.marshal((Object)resource, (Writer)writer);
        return writer.toString();
    }

    private Set<String> filterICContexts(Collection<String> contexts) {
        return contexts.stream().map(c -> {
            ContextBean bean = new ContextBean(c);
            return bean.is(ContextBean.Type.VRE) ? bean.enclosingScope().toString() : c;
        }).collect(Collectors.toSet());
    }

    private <T extends Resource> boolean isCompatibleScopeForRemove(T resource, String scope) {
        if (resource.scopes().size() == 0) {
            return true;
        }
        if (new ContextBean(scope).is(ContextBean.Type.VRE)) {
            return !this.anotherBrotherVREOrVOOnResource(resource, scope);
        }
        if (new ContextBean(scope).is(ContextBean.Type.VO)) {
            return !this.anotherSonVREOnResource(resource, scope);
        }
        return !this.anotherInfraScopeOnResource(resource, scope);
    }

    private <T extends Resource> boolean anotherBrotherVREOrVOOnResource(T resource, String scope) {
        if (!new ContextBean(scope).is(ContextBean.Type.VRE)) {
            throw new IllegalArgumentException("anotherBrotherVREOrVOOnResource method: the input scope must be a VRE scope");
        }
        String enclosedScope = new ContextBean(scope).enclosingScope().toString();
        for (String s : resource.scopes()) {
            if (!this.isChildScope(enclosedScope, s) && (enclosedScope == null || !enclosedScope.toString().equals(s))) continue;
            return true;
        }
        return false;
    }

    private <T extends Resource> boolean anotherSonVREOnResource(T resource, String scope) {
        if (!new ContextBean(scope).is(ContextBean.Type.VO)) {
            throw new IllegalArgumentException("anotherSonVREOnResource method: the input scope must be a VO scope");
        }
        for (String s : resource.scopes()) {
            if (!this.isChildScope(scope, s)) continue;
            return true;
        }
        return false;
    }

    private boolean isChildScope(String fatherScope, String sonScope) {
        ContextBean currentEnclosedScope = new ContextBean(sonScope).enclosingScope();
        return currentEnclosedScope != null && currentEnclosedScope.toString().equals(fatherScope);
    }

    private <T extends Resource> boolean anotherInfraScopeOnResource(T resource, String scope) {
        if (!new ContextBean(scope).is(ContextBean.Type.INFRASTRUCTURE)) {
            throw new IllegalArgumentException("anotherInfraScopeOnResource method: the input scope must be a INFRASTRUCTURE scope");
        }
        String infraScopeFound = null;
        for (String s : resource.scopes()) {
            while (new ContextBean(s).enclosingScope() != null) {
                s = new ContextBean(s).enclosingScope().toString();
            }
            infraScopeFound = s;
            if (!infraScopeFound.equals(scope)) continue;
            return true;
        }
        return false;
    }
}

