/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.documentstore.records.implementation.validations.validators;

import java.io.Serializable;
import java.util.Map;
import org.gcube.documentstore.exception.InvalidValueException;
import org.gcube.documentstore.records.Record;
import org.gcube.documentstore.records.implementation.FieldAction;

public class NotEmptyValidator
implements FieldAction {
    private static final String ERROR = "Is Empty";

    protected boolean isValid(Serializable toValidate) {
        if (toValidate == null) {
            return false;
        }
        if (toValidate.getClass().isArray()) {
            return ((Object[])toValidate).length > 0;
        }
        if (toValidate instanceof Iterable) {
            return ((Iterable)((Object)toValidate)).iterator().hasNext();
        }
        if (toValidate instanceof Map) {
            return ((Map)((Object)toValidate)).size() > 0;
        }
        if (toValidate instanceof String) {
            return !((String)((Object)toValidate)).isEmpty();
        }
        return true;
    }

    @Override
    public Serializable validate(String key, Serializable value, Record record) throws InvalidValueException {
        try {
            if (this.isValid(value)) {
                return value;
            }
        }
        catch (Exception e) {
            throw new InvalidValueException(ERROR, e);
        }
        throw new InvalidValueException(ERROR);
    }
}

