/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.encryption.encrypter;

import java.security.Key;
import javax.crypto.Cipher;
import javax.xml.bind.DatatypeConverter;
import org.gcube.common.encryption.SymmetricKey;
import org.gcube.common.encryption.encrypter.Encrypter;

public class StringEncrypter
implements Encrypter<String> {
    private static StringEncrypter singleton;

    private StringEncrypter() {
    }

    public static StringEncrypter getEncrypter() {
        if (singleton == null) {
            singleton = new StringEncrypter();
        }
        return singleton;
    }

    @Override
    public String encrypt(String string) throws Exception {
        Key ekey = SymmetricKey.getKey();
        return this.encrypt(string, ekey);
    }

    @Override
    public String encrypt(String string, Key ekey) throws Exception {
        Cipher cipher = Cipher.getInstance(ekey.getAlgorithm());
        cipher.init(1, ekey);
        return new String(DatatypeConverter.printBase64Binary((byte[])cipher.doFinal(string.getBytes())));
    }

    @Override
    public String decrypt(String string) throws Exception {
        Key dkey = SymmetricKey.getKey();
        return this.decrypt(string, dkey);
    }

    @Override
    public String decrypt(String string, Key dkey) throws Exception {
        Cipher cipher = Cipher.getInstance(dkey.getAlgorithm());
        cipher.init(2, dkey);
        return new String(cipher.doFinal(DatatypeConverter.parseBase64Binary((String)string)));
    }
}

