/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.accounting.datamodel.validations.validators;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.regex.Pattern;

public class MultiMatcher {
    protected String serviceClassRegex;
    @JsonIgnore
    protected Pattern serviceClassPattern;
    protected String serviceNameRegex;
    @JsonIgnore
    protected Pattern serviceNamePattern;
    protected String calledMethodRegex;
    @JsonIgnore
    protected Pattern calledMethodPattern;

    protected MultiMatcher() {
    }

    public MultiMatcher(String serviceClassRegex, String serviceNameRegex, String calledMethodRegex) {
        this.setServiceClassRegex(serviceClassRegex);
        this.setServiceNameRegex(serviceNameRegex);
        this.setCalledMethodRegex(calledMethodRegex);
    }

    protected Pattern getPattern(String regex) {
        return Pattern.compile(regex, 2);
    }

    public String getServiceClassRegex() {
        return this.serviceClassRegex;
    }

    public void setServiceClassRegex(String serviceClassRegex) {
        this.serviceClassRegex = serviceClassRegex;
        this.serviceClassPattern = this.getPattern(serviceClassRegex);
    }

    public String getServiceNameRegex() {
        return this.serviceNameRegex;
    }

    public void setServiceNameRegex(String serviceNameRegex) {
        this.serviceNameRegex = serviceNameRegex;
        this.serviceNamePattern = this.getPattern(serviceNameRegex);
    }

    public String getCalledMethodRegex() {
        return this.calledMethodRegex;
    }

    public void setCalledMethodRegex(String calledMethodRegex) {
        this.calledMethodRegex = calledMethodRegex;
        this.calledMethodPattern = this.getPattern(calledMethodRegex);
    }

    @JsonIgnore
    public boolean match(String serviceClass, String serviceName, String calledMethod) {
        return this.serviceClassPattern.matcher(serviceClass).matches() && this.serviceNamePattern.matcher(serviceName).matches() && this.calledMethodPattern.matcher(calledMethod).matches();
    }

    public String toString() {
        return "MultiMatcher [serviceClassRegex=" + this.serviceClassRegex + ", serviceNameRegex=" + this.serviceNameRegex + ", calledMethodRegex=" + this.calledMethodRegex + "]";
    }
}

