/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.util;

import java.util.Queue;
import rx.Observer;
import rx.Subscription;
import rx.exceptions.MissingBackpressureException;
import rx.internal.operators.NotificationLite;
import rx.internal.util.ObjectPool;
import rx.internal.util.PlatformDependent;
import rx.internal.util.SynchronizedQueue;
import rx.internal.util.unsafe.SpmcArrayQueue;
import rx.internal.util.unsafe.SpscArrayQueue;
import rx.internal.util.unsafe.UnsafeAccess;

public class RxRingBuffer
implements Subscription {
    private static final NotificationLite<Object> ON;
    private Queue<Object> queue;
    private final int size;
    private final ObjectPool<Queue<Object>> pool;
    public volatile Object terminalState;
    static int defaultSize;
    public static final int SIZE;
    public static final ObjectPool<Queue<Object>> SPSC_POOL;
    public static final ObjectPool<Queue<Object>> SPMC_POOL;

    public static RxRingBuffer getSpscInstance() {
        if (UnsafeAccess.isUnsafeAvailable()) {
            return new RxRingBuffer(SPSC_POOL, SIZE);
        }
        return new RxRingBuffer();
    }

    public static RxRingBuffer getSpmcInstance() {
        if (UnsafeAccess.isUnsafeAvailable()) {
            return new RxRingBuffer(SPMC_POOL, SIZE);
        }
        return new RxRingBuffer();
    }

    private RxRingBuffer(Queue<Object> queue, int size) {
        this.queue = queue;
        this.pool = null;
        this.size = size;
    }

    private RxRingBuffer(ObjectPool<Queue<Object>> pool, int size) {
        this.pool = pool;
        this.queue = pool.borrowObject();
        this.size = size;
    }

    public synchronized void release() {
        Queue<Object> q = this.queue;
        ObjectPool<Queue<Object>> p = this.pool;
        if (p != null && q != null) {
            q.clear();
            this.queue = null;
            p.returnObject(q);
        }
    }

    @Override
    public void unsubscribe() {
        this.release();
    }

    RxRingBuffer() {
        this(new SynchronizedQueue<Object>(SIZE), SIZE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onNext(Object o) throws MissingBackpressureException {
        boolean iae = false;
        boolean mbe = false;
        RxRingBuffer rxRingBuffer = this;
        synchronized (rxRingBuffer) {
            Queue<Object> q = this.queue;
            if (q != null) {
                mbe = !q.offer(ON.next(o));
            } else {
                iae = true;
            }
        }
        if (iae) {
            throw new IllegalStateException("This instance has been unsubscribed and the queue is no longer usable.");
        }
        if (mbe) {
            throw new MissingBackpressureException();
        }
    }

    public void onCompleted() {
        if (this.terminalState == null) {
            this.terminalState = ON.completed();
        }
    }

    public void onError(Throwable t) {
        if (this.terminalState == null) {
            this.terminalState = ON.error(t);
        }
    }

    public int available() {
        return this.size - this.count();
    }

    public int capacity() {
        return this.size;
    }

    public int count() {
        Queue<Object> q = this.queue;
        if (q == null) {
            return 0;
        }
        return q.size();
    }

    public boolean isEmpty() {
        Queue<Object> q = this.queue;
        if (q == null) {
            return true;
        }
        return q.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object poll() {
        Object o;
        RxRingBuffer rxRingBuffer = this;
        synchronized (rxRingBuffer) {
            Queue<Object> q = this.queue;
            if (q == null) {
                return null;
            }
            o = q.poll();
            Object ts = this.terminalState;
            if (o == null && ts != null && q.peek() == null) {
                o = ts;
                this.terminalState = null;
            }
        }
        return o;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object peek() {
        Object o;
        RxRingBuffer rxRingBuffer = this;
        synchronized (rxRingBuffer) {
            Queue<Object> q = this.queue;
            if (q == null) {
                return null;
            }
            o = q.peek();
            Object ts = this.terminalState;
            if (o == null && ts != null && q.peek() == null) {
                o = ts;
            }
        }
        return o;
    }

    public boolean isCompleted(Object o) {
        return ON.isCompleted(o);
    }

    public boolean isError(Object o) {
        return ON.isError(o);
    }

    public Object getValue(Object o) {
        return ON.getValue(o);
    }

    public boolean accept(Object o, Observer child) {
        return ON.accept(child, o);
    }

    public Throwable asError(Object o) {
        return ON.getError(o);
    }

    @Override
    public boolean isUnsubscribed() {
        return this.queue == null;
    }

    static {
        String sizeFromProperty;
        ON = NotificationLite.instance();
        defaultSize = 128;
        if (PlatformDependent.isAndroid()) {
            defaultSize = 16;
        }
        if ((sizeFromProperty = System.getProperty("rx.ring-buffer.size")) != null) {
            try {
                defaultSize = Integer.parseInt(sizeFromProperty);
            }
            catch (NumberFormatException e) {
                System.err.println("Failed to set 'rx.buffer.size' with value " + sizeFromProperty + " => " + e.getMessage());
            }
        }
        SIZE = defaultSize;
        SPSC_POOL = new ObjectPool<Queue<Object>>(){

            @Override
            protected SpscArrayQueue<Object> createObject() {
                return new SpscArrayQueue<Object>(SIZE);
            }
        };
        SPMC_POOL = new ObjectPool<Queue<Object>>(){

            @Override
            protected SpmcArrayQueue<Object> createObject() {
                return new SpmcArrayQueue<Object>(SIZE);
            }
        };
    }
}

