/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.test;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class CaptureHandler
extends Handler {
    private Handler[] _handlers;
    private Level _level;
    private Logger _logger;
    private List<LogRecord> _logRecords = new CopyOnWriteArrayList<LogRecord>();
    private boolean _useParentHandlers;

    public CaptureHandler(Logger logger, Level level) {
        this._logger = logger;
        this._handlers = logger.getHandlers();
        this._level = logger.getLevel();
        this._useParentHandlers = logger.getUseParentHandlers();
        Handler[] handlerArray = this._handlers;
        int n = this._handlers.length;
        int n2 = 0;
        while (n2 < n) {
            Handler handler = handlerArray[n2];
            logger.removeHandler(handler);
            ++n2;
        }
        logger.setLevel(level);
        logger.setUseParentHandlers(false);
    }

    @Override
    public void close() throws SecurityException {
        this._logRecords.clear();
        this._logger.removeHandler(this);
        Handler[] handlerArray = this._handlers;
        int n = this._handlers.length;
        int n2 = 0;
        while (n2 < n) {
            Handler handler = handlerArray[n2];
            this._logger.addHandler(handler);
            ++n2;
        }
        this._logger.setLevel(this._level);
        this._logger.setUseParentHandlers(this._useParentHandlers);
    }

    @Override
    public void flush() {
        this._logRecords.clear();
    }

    public List<LogRecord> getLogRecords() {
        return this._logRecords;
    }

    @Override
    public boolean isLoggable(LogRecord logRecord) {
        return false;
    }

    @Override
    public void publish(LogRecord logRecord) {
        this._logRecords.add(logRecord);
    }

    public List<LogRecord> resetLogLevel(Level level) {
        this._logRecords.clear();
        this._logger.setLevel(level);
        return this._logRecords;
    }
}

