/*
 * Decompiled with CFR 0.152.
 */
package org.jamwiki;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.jamwiki.DataAccessException;
import org.jamwiki.WikiException;
import org.jamwiki.model.Category;
import org.jamwiki.model.Interwiki;
import org.jamwiki.model.LogItem;
import org.jamwiki.model.Namespace;
import org.jamwiki.model.RecentChange;
import org.jamwiki.model.Role;
import org.jamwiki.model.RoleMap;
import org.jamwiki.model.Topic;
import org.jamwiki.model.TopicType;
import org.jamwiki.model.TopicVersion;
import org.jamwiki.model.VirtualWiki;
import org.jamwiki.model.Watchlist;
import org.jamwiki.model.WikiFile;
import org.jamwiki.model.WikiFileVersion;
import org.jamwiki.model.WikiGroup;
import org.jamwiki.model.WikiUser;
import org.jamwiki.utils.Pagination;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface DataHandler {
    public static final String DATA_HANDLER_ANSI = "org.jamwiki.db.AnsiDataHandler";
    public static final String DATA_HANDLER_DB2 = "org.jamwiki.db.DB2DataHandler";
    public static final String DATA_HANDLER_DB2400 = "org.jamwiki.db.DB2400DataHandler";
    public static final String DATA_HANDLER_HSQL = "org.jamwiki.db.HSqlDataHandler";
    public static final String DATA_HANDLER_MSSQL = "org.jamwiki.db.MSSqlDataHandler";
    public static final String DATA_HANDLER_MYSQL = "org.jamwiki.db.MySqlDataHandler";
    public static final String DATA_HANDLER_ORACLE = "org.jamwiki.db.OracleDataHandler";
    public static final String DATA_HANDLER_POSTGRES = "org.jamwiki.db.PostgresDataHandler";
    public static final String DATA_HANDLER_ASA = "org.jamwiki.db.SybaseASADataHandler";
    public static final String DATA_HANDLER_CACHE = "org.jamwiki.db.CacheDataHandler";

    public boolean authenticate(String var1, String var2) throws DataAccessException;

    public boolean canMoveTopic(Topic var1, String var2) throws DataAccessException;

    public void deleteInterwiki(Interwiki var1) throws DataAccessException;

    public void deleteTopic(Topic var1, TopicVersion var2) throws DataAccessException, WikiException;

    public void executeUpgradeQuery(String var1, Connection var2) throws SQLException;

    public void executeUpgradeUpdate(String var1, Connection var2) throws SQLException;

    public List<Category> getAllCategories(String var1, Pagination var2) throws DataAccessException;

    public List<Role> getAllRoles() throws DataAccessException;

    public List<String> getAllTopicNames(String var1, boolean var2) throws DataAccessException;

    public List<WikiFileVersion> getAllWikiFileVersions(String var1, String var2, boolean var3) throws DataAccessException;

    public List<LogItem> getLogItems(String var1, int var2, Pagination var3, boolean var4) throws DataAccessException;

    public List<RecentChange> getRecentChanges(String var1, Pagination var2, boolean var3) throws DataAccessException;

    public List<RoleMap> getRoleMapByLogin(String var1) throws DataAccessException;

    public List<RoleMap> getRoleMapByRole(String var1) throws DataAccessException;

    public List<Role> getRoleMapGroup(String var1) throws DataAccessException;

    public List<RoleMap> getRoleMapGroups() throws DataAccessException;

    public List<Role> getRoleMapUser(String var1) throws DataAccessException;

    public List<RecentChange> getTopicHistory(String var1, String var2, Pagination var3, boolean var4) throws DataAccessException;

    public List<String> getTopicsAdmin(String var1, Pagination var2) throws DataAccessException;

    public List<RecentChange> getUserContributions(String var1, String var2, Pagination var3, boolean var4) throws DataAccessException;

    public List<VirtualWiki> getVirtualWikiList() throws DataAccessException;

    public Watchlist getWatchlist(String var1, int var2) throws DataAccessException;

    public List<RecentChange> getWatchlist(String var1, int var2, Pagination var3) throws DataAccessException;

    public List<Category> lookupCategoryTopics(String var1, String var2) throws DataAccessException;

    public Map<String, String> lookupConfiguration() throws DataAccessException;

    public Interwiki lookupInterwiki(String var1) throws DataAccessException;

    public List<Interwiki> lookupInterwikis() throws DataAccessException;

    public Namespace lookupNamespace(String var1, String var2) throws DataAccessException;

    public Namespace lookupNamespaceById(int var1) throws DataAccessException;

    public List<Namespace> lookupNamespaces() throws DataAccessException;

    public Topic lookupTopic(String var1, String var2, boolean var3, Connection var4) throws DataAccessException;

    public Topic lookupTopicById(String var1, int var2) throws DataAccessException;

    public int lookupTopicCount(String var1, Integer var2) throws DataAccessException;

    public Map<Integer, String> lookupTopicByType(String var1, TopicType var2, TopicType var3, Integer var4, Pagination var5) throws DataAccessException;

    public String lookupTopicName(String var1, String var2) throws DataAccessException;

    public TopicVersion lookupTopicVersion(int var1) throws DataAccessException;

    public Integer lookupTopicVersionNextId(int var1) throws DataAccessException;

    public List<String> lookupTopicLinks(String var1, String var2) throws DataAccessException;

    public List<String> lookupTopicLinkOrphans(String var1, int var2) throws DataAccessException;

    public VirtualWiki lookupVirtualWiki(String var1) throws DataAccessException;

    public WikiFile lookupWikiFile(String var1, String var2) throws DataAccessException;

    public int lookupWikiFileCount(String var1) throws DataAccessException;

    public WikiGroup lookupWikiGroup(String var1) throws DataAccessException;

    public WikiUser lookupWikiUser(int var1) throws DataAccessException;

    public WikiUser lookupWikiUser(String var1) throws DataAccessException;

    public int lookupWikiUserCount() throws DataAccessException;

    public String lookupWikiUserEncryptedPassword(String var1) throws DataAccessException;

    public List<String> lookupWikiUsers(Pagination var1) throws DataAccessException;

    public void moveTopic(Topic var1, TopicVersion var2, String var3) throws DataAccessException, WikiException;

    public void orderTopicVersions(Topic var1, List<Integer> var2) throws DataAccessException;

    public void reloadLogItems() throws DataAccessException;

    public void reloadRecentChanges() throws DataAccessException;

    public void setup(Locale var1, WikiUser var2, String var3, String var4) throws DataAccessException, WikiException;

    public void setupSpecialPages(Locale var1, WikiUser var2, VirtualWiki var3) throws DataAccessException, WikiException;

    public void undeleteTopic(Topic var1, TopicVersion var2) throws DataAccessException, WikiException;

    public void updateSpecialPage(Locale var1, String var2, String var3, String var4) throws DataAccessException, WikiException;

    public void writeConfiguration(Map<String, String> var1) throws DataAccessException, WikiException;

    public void writeFile(WikiFile var1, WikiFileVersion var2) throws DataAccessException, WikiException;

    public void writeInterwiki(Interwiki var1) throws DataAccessException, WikiException;

    public void writeNamespace(Namespace var1, Namespace var2) throws DataAccessException, WikiException;

    public void writeNamespaceTranslations(List<Namespace> var1, String var2) throws DataAccessException, WikiException;

    public void writeRole(Role var1, boolean var2) throws DataAccessException, WikiException;

    public void writeRoleMapGroup(int var1, List<String> var2) throws DataAccessException, WikiException;

    public void writeRoleMapUser(String var1, List<String> var2) throws DataAccessException, WikiException;

    public void writeTopic(Topic var1, TopicVersion var2, LinkedHashMap<String, String> var3, List<String> var4) throws DataAccessException, WikiException;

    public void writeTopicVersion(Topic var1, TopicVersion var2) throws DataAccessException, WikiException;

    public void writeVirtualWiki(VirtualWiki var1) throws DataAccessException, WikiException;

    public void writeWatchlistEntry(Watchlist var1, String var2, String var3, int var4) throws DataAccessException, WikiException;

    public void writeWikiGroup(WikiGroup var1) throws DataAccessException, WikiException;

    public void writeWikiUser(WikiUser var1, String var2, String var3) throws DataAccessException, WikiException;
}

