/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.scripting.groovy;

import com.liferay.portal.kernel.scripting.BaseScriptingExecutor;
import com.liferay.portal.kernel.scripting.ExecutionException;
import com.liferay.portal.kernel.scripting.ScriptingException;
import com.liferay.portal.kernel.util.AggregateClassLoader;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.util.ClassLoaderUtil;
import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import groovy.lang.Script;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;

public class GroovyExecutor
extends BaseScriptingExecutor {
    private static final String _LANGUAGE = "groovy";
    private volatile GroovyShell _groovyShell = new GroovyShell();
    private volatile Map<ClassLoader, GroovyShell> _groovyShells = new WeakHashMap<ClassLoader, GroovyShell>();

    public Map<String, Object> eval(Set<String> allowedClasses, Map<String, Object> inputObjects, Set<String> outputNames, String script, ClassLoader ... classLoaders) throws ScriptingException {
        if (allowedClasses != null) {
            throw new ExecutionException("Constrained execution not supported for Groovy");
        }
        GroovyShell groovyShell = this.getGroovyShell(classLoaders);
        Script compiledScript = groovyShell.parse(script);
        Binding binding = new Binding(inputObjects);
        compiledScript.setBinding(binding);
        compiledScript.run();
        if (outputNames == null) {
            return null;
        }
        HashMap<String, Object> outputObjects = new HashMap<String, Object>();
        for (String outputName : outputNames) {
            outputObjects.put(outputName, binding.getVariable(outputName));
        }
        return outputObjects;
    }

    public String getLanguage() {
        return _LANGUAGE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected GroovyShell getGroovyShell(ClassLoader[] classLoaders) {
        if (ArrayUtil.isEmpty((Object[])classLoaders)) {
            if (this._groovyShell == null) {
                GroovyExecutor groovyExecutor = this;
                synchronized (groovyExecutor) {
                    if (this._groovyShell == null) {
                        this._groovyShell = new GroovyShell();
                    }
                }
            }
            return this._groovyShell;
        }
        ClassLoader aggregateClassLoader = AggregateClassLoader.getAggregateClassLoader((ClassLoader)ClassLoaderUtil.getPortalClassLoader(), (ClassLoader[])classLoaders);
        GroovyShell groovyShell = null;
        if (!this._groovyShells.containsKey(aggregateClassLoader)) {
            GroovyExecutor groovyExecutor = this;
            synchronized (groovyExecutor) {
                if (!this._groovyShells.containsKey(aggregateClassLoader)) {
                    groovyShell = new GroovyShell(aggregateClassLoader);
                    this._groovyShells.put(aggregateClassLoader, groovyShell);
                }
            }
        }
        return groovyShell;
    }
}

