/*
 * Decompiled with CFR 0.152.
 */
package org.walluck.oscar;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import java.util.Timer;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.walluck.oscar.AIMConnection;
import org.walluck.oscar.ListenerEntry;
import org.walluck.oscar.LoginResponseInfo;
import org.walluck.oscar.channel.rendezvous.AddInsRendezvous;
import org.walluck.oscar.channel.rendezvous.BuddyIconRendezvous;
import org.walluck.oscar.channel.rendezvous.ChatRendezvous;
import org.walluck.oscar.channel.rendezvous.DirectIMRendezvous;
import org.walluck.oscar.channel.rendezvous.GetFileRendezvous;
import org.walluck.oscar.channel.rendezvous.ICQGetAwayRendezvous;
import org.walluck.oscar.channel.rendezvous.ICQRTFRendezvous;
import org.walluck.oscar.channel.rendezvous.Rendezvous;
import org.walluck.oscar.channel.rendezvous.SendBuddyListRendezvous;
import org.walluck.oscar.channel.rendezvous.SendFileRendezvous;
import org.walluck.oscar.channel.rendezvous.TalkRendezvous;
import org.walluck.oscar.channel.rendezvous.TrillianSecureIMRendezvous;
import org.walluck.oscar.handlers.AdminHandler;
import org.walluck.oscar.handlers.AdvertHandler;
import org.walluck.oscar.handlers.BOSHandler;
import org.walluck.oscar.handlers.BuddyListHandler;
import org.walluck.oscar.handlers.ChatHandler;
import org.walluck.oscar.handlers.ChatNavHandler;
import org.walluck.oscar.handlers.ICBMHandler;
import org.walluck.oscar.handlers.ICQHandler;
import org.walluck.oscar.handlers.IconHandler;
import org.walluck.oscar.handlers.InviteHandler;
import org.walluck.oscar.handlers.Listener;
import org.walluck.oscar.handlers.LocateHandler;
import org.walluck.oscar.handlers.LoginHandler;
import org.walluck.oscar.handlers.MailHandler;
import org.walluck.oscar.handlers.MiscHandler;
import org.walluck.oscar.handlers.ODirHandler;
import org.walluck.oscar.handlers.PopupHandler;
import org.walluck.oscar.handlers.SNACHandler;
import org.walluck.oscar.handlers.SSIHandler;
import org.walluck.oscar.handlers.ServiceHandler;
import org.walluck.oscar.handlers.StatsHandler;
import org.walluck.oscar.handlers.TranslateHandler;
import org.walluck.oscar.handlers.UserLookupHandler;
import org.walluck.oscar.script.ScriptInterpreter;
import org.walluck.oscar.tools.AdminTool;
import org.walluck.oscar.tools.AdvertTool;
import org.walluck.oscar.tools.BOSTool;
import org.walluck.oscar.tools.BuddyListTool;
import org.walluck.oscar.tools.ChatNavTool;
import org.walluck.oscar.tools.ChatTool;
import org.walluck.oscar.tools.ICBMTool;
import org.walluck.oscar.tools.ICQTool;
import org.walluck.oscar.tools.IconTool;
import org.walluck.oscar.tools.InviteTool;
import org.walluck.oscar.tools.LocateTool;
import org.walluck.oscar.tools.LoginTool;
import org.walluck.oscar.tools.MailTool;
import org.walluck.oscar.tools.MiscTool;
import org.walluck.oscar.tools.ODirTool;
import org.walluck.oscar.tools.PopupTool;
import org.walluck.oscar.tools.SSITool;
import org.walluck.oscar.tools.ServiceTool;
import org.walluck.oscar.tools.StatsTool;
import org.walluck.oscar.tools.Tool;
import org.walluck.oscar.tools.TranslateTool;
import org.walluck.oscar.tools.UserLookupTool;

public class AIMSession {
    private static final Logger LOG = Logger.getLogger((String)(class$org$walluck$oscar$AIMSession == null ? (class$org$walluck$oscar$AIMSession = AIMSession.class$("org.walluck.oscar.AIMSession")) : class$org$walluck$oscar$AIMSession).getName());
    private String sn;
    private Object auxData;
    private SSIObject ssi;
    private Vector connList;
    private int flags;
    private ArrayList handlers;
    private ArrayList tools;
    private ArrayList rendezvous;
    private ScriptInterpreter si;
    private Timer timer;
    private boolean icq;
    private boolean iChat;
    private Vector listenerEntries = new Vector(20);
    private LoginResponseInfo loginInfo;
    private ArrayList emailInfo = new ArrayList(0);
    static /* synthetic */ Class class$org$walluck$oscar$AIMSession;

    public AIMSession() {
        Properties properties = System.getProperties();
        properties.put("http.agent", "AIM/30 (Mozilla 1.24b; Windows ; I; 32-bit)");
    }

    public void init() {
        this.ssi = new SSIObject();
        this.connList = new Vector(6);
        this.handlers = new ArrayList(20);
        this.registerHandlers();
        this.tools = new ArrayList(20);
        this.registerTools();
        this.registerRendezous();
        this.timer = new Timer();
    }

    public void registerHandlers() {
        this.handlers.add(new MiscHandler());
        this.handlers.add(new LoginHandler());
        this.handlers.add(new ServiceHandler());
        SSIHandler ssiHandler = new SSIHandler();
        this.handlers.add(ssiHandler);
        this.handlers.add(new LocateHandler());
        this.handlers.add(new BuddyListHandler());
        if (this.icq) {
            this.handlers.add(new ICQHandler());
        }
        this.handlers.add(new ICBMHandler());
        this.handlers.add(new AdvertHandler());
        this.handlers.add(new InviteHandler());
        this.handlers.add(new AdminHandler());
        if (!this.icq) {
            this.handlers.add(new PopupHandler());
        }
        this.handlers.add(new BOSHandler());
        this.handlers.add(new UserLookupHandler());
        this.handlers.add(new StatsHandler());
        if (!this.icq) {
            this.handlers.add(new TranslateHandler());
            this.handlers.add(new ChatNavHandler());
            this.handlers.add(new ChatHandler());
            this.handlers.add(new ODirHandler());
            this.handlers.add(new IconHandler());
        }
        if (!this.icq) {
            this.handlers.add(new MailHandler());
        }
    }

    public SNACHandler getHandler(int family) {
        int size = this.handlers.size();
        for (int i = 0; i < size; ++i) {
            SNACHandler handler = (SNACHandler)this.handlers.get(i);
            if (handler.getFamily() != family) continue;
            return handler;
        }
        return null;
    }

    public ArrayList getHandlers() {
        return this.handlers;
    }

    public void registerTools() {
        this.tools.add(new MiscTool());
        this.tools.add(new LoginTool());
        this.tools.add(new ServiceTool());
        this.tools.add(new SSITool());
        this.tools.add(new LocateTool());
        this.tools.add(new BuddyListTool());
        if (this.icq) {
            this.tools.add(new ICQTool());
        }
        this.tools.add(new ICBMTool());
        this.tools.add(new AdvertTool());
        this.tools.add(new InviteTool());
        this.tools.add(new AdminTool());
        if (!this.icq) {
            this.tools.add(new PopupTool());
        }
        this.tools.add(new BOSTool());
        this.tools.add(new UserLookupTool());
        this.tools.add(new StatsTool());
        if (!this.icq) {
            this.tools.add(new TranslateTool());
            this.tools.add(new ChatNavTool());
            this.tools.add(new ChatTool());
            this.tools.add(new ODirTool());
            this.tools.add(new IconTool());
        }
        if (!this.icq) {
            this.tools.add(new MailTool());
        }
    }

    public Tool getTool(int family) {
        int size = this.tools.size();
        for (int i = 0; i < size; ++i) {
            Tool tool = (Tool)this.tools.get(i);
            if (tool.getFamily() != family) continue;
            return tool;
        }
        return null;
    }

    public ArrayList getTools() {
        return this.tools;
    }

    public void registerRendezous() {
        if (this.icq) {
            this.rendezvous = new ArrayList(3);
            this.rendezvous.add(new ICQRTFRendezvous());
            this.rendezvous.add(new ICQGetAwayRendezvous());
            this.rendezvous.add(new TrillianSecureIMRendezvous());
            return;
        }
        this.rendezvous = new ArrayList(9);
        this.rendezvous.add(new AddInsRendezvous());
        this.rendezvous.add(new BuddyIconRendezvous());
        this.rendezvous.add(new ChatRendezvous());
        this.rendezvous.add(new DirectIMRendezvous());
        this.rendezvous.add(new GetFileRendezvous());
        this.rendezvous.add(new SendFileRendezvous());
        this.rendezvous.add(new SendBuddyListRendezvous());
        this.rendezvous.add(new TalkRendezvous());
        this.rendezvous.add(new TrillianSecureIMRendezvous());
    }

    public Rendezvous getRendezvous(int service) {
        int size = this.rendezvous.size();
        for (int i = 0; i < size; ++i) {
            Rendezvous rv = (Rendezvous)this.rendezvous.get(i);
            if (rv.getService() != service) continue;
            return rv;
        }
        return null;
    }

    public ArrayList getRendezvous() {
        return this.rendezvous;
    }

    public void setScriptInterpreter(ScriptInterpreter si) {
        this.si = si;
    }

    public ScriptInterpreter getScriptInterpreter() {
        return this.si;
    }

    public void setTimer(Timer timer) {
        this.timer = timer;
    }

    public Timer getTimer() {
        return this.timer;
    }

    public void kill() {
        Iterator i = this.connList.iterator();
        while (i.hasNext()) {
            AIMConnection conn = (AIMConnection)i.next();
            conn.cleanSNACs(-1);
            conn.cleanCookies(-1);
            conn.logOff(this);
        }
    }

    public String getSN() {
        return this.sn;
    }

    public void setSN(String sn) {
        this.sn = sn;
    }

    public boolean isICQ() {
        return this.icq;
    }

    public void setICQ(boolean icq) {
        this.icq = icq;
    }

    public boolean isIChat() {
        return this.iChat;
    }

    public void setIChat(boolean iChat) {
        this.iChat = iChat;
    }

    public void addConn(AIMConnection conn) {
        this.connList.add(conn);
    }

    public void remConn(AIMConnection conn) {
        this.connList.remove(conn);
    }

    public Vector getConnList() {
        return this.connList;
    }

    public int getFlags() {
        return this.flags;
    }

    public void setFlags(int flags) {
        this.flags = flags;
    }

    public SSIObject getSSI() {
        return this.ssi;
    }

    public void setSSI(SSIObject ssi) {
        this.ssi = ssi;
    }

    public Object getAuxData() {
        return this.auxData;
    }

    public void setAuxData(Object auxData) {
        this.auxData = auxData;
    }

    public LoginResponseInfo getLoginInfo() {
        return this.loginInfo;
    }

    public void setLoginInfo(LoginResponseInfo loginInfo) {
        this.loginInfo = loginInfo;
    }

    public ArrayList getEmailInfo() {
        return this.emailInfo;
    }

    public void setEmailInfo(ArrayList emailInfo) {
        this.emailInfo = emailInfo;
    }

    public synchronized ListenerEntry lookupListenerEntry(int family, int subtype) {
        Iterator i = this.listenerEntries.iterator();
        while (i.hasNext()) {
            ListenerEntry le = (ListenerEntry)i.next();
            if (le.getFamily() != family || le.getSubtype() != subtype) continue;
            return le;
        }
        return null;
    }

    public synchronized ListenerEntry lookupListenerEntryCreate(int family, int subtype) {
        ListenerEntry le = this.lookupListenerEntry(family, subtype);
        if (le == null) {
            LOG.debug((Object)("Creating listener entry for " + Integer.toHexString(family) + "/" + Integer.toHexString(subtype) + ". This should only be called once for each " + "family/subtype pair."));
            le = new ListenerEntry(family, subtype);
            this.listenerEntries.add(le);
        }
        return le;
    }

    public synchronized void registerListener(int family, int subtype, Listener listener) {
        ListenerEntry le = this.lookupListenerEntryCreate(family, subtype);
        le.getListeners().add(listener);
    }

    public synchronized void deregisiterListener(int family, int subtype, Listener listener) {
        ListenerEntry le = this.lookupListenerEntry(family, subtype);
        le.getListeners().remove(listener);
    }

    public synchronized Iterator getListeners(int family, int subtype) {
        ListenerEntry le = this.lookupListenerEntry(family, subtype);
        if (le != null) {
            return le.getListeners().iterator();
        }
        return new Vector(0).iterator();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class SSIObject {
        private boolean receivedData;
        private boolean waitingForAck;
        private int numItems;
        private Vector official;
        private Vector local;
        private Vector pending;
        private int timestamp;

        public boolean getReceivedData() {
            return this.receivedData;
        }

        public void setReceivedData(boolean receivedData) {
            this.receivedData = receivedData;
        }

        public void setWaitingForAck(boolean waitingForAck) {
            this.waitingForAck = waitingForAck;
        }

        public boolean isWaitingForAck() {
            return this.waitingForAck;
        }

        public void setNumItems(int numItems) {
            this.numItems = numItems;
        }

        public int getNumItems() {
            return this.numItems;
        }

        public Vector getOfficial() {
            return this.official;
        }

        public void setOfficial(Vector official) {
            this.official = official;
        }

        public Vector getLocal() {
            return this.local;
        }

        public void setLocal(Vector local) {
            this.local = local;
        }

        public Vector getPending() {
            return this.pending;
        }

        public void setPending(Vector pending) {
            this.pending = pending;
        }

        public int getTimestamp() {
            return this.timestamp;
        }

        public void setTimestamp(int timestamp) {
            this.timestamp = timestamp;
        }
    }
}

