/*
 * Decompiled with CFR 0.152.
 */
package org.apache.abdera.security.util.filters;

import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPublicKey;
import org.apache.abdera.protocol.server.RequestContext;
import org.apache.abdera.protocol.server.ResponseContext;
import org.apache.abdera.security.Encryption;
import org.apache.abdera.security.EncryptionOptions;
import org.apache.abdera.security.util.KeyHelper;
import org.apache.abdera.security.util.filters.AbstractEncryptedResponseFilter;

public class AESEncryptedResponseFilter
extends AbstractEncryptedResponseFilter {
    public static final String PUBLICKEY = "X-PublicKey";

    protected X509Certificate[] getCerts(RequestContext request) {
        return (X509Certificate[])request.getAttribute(RequestContext.Scope.REQUEST, "javax.servlet.request.X509Certificate");
    }

    protected PublicKey getPublicKey(RequestContext request) {
        String header = request.getHeader(PUBLICKEY);
        PublicKey pkey = KeyHelper.generatePublicKey(header);
        if (pkey == null) {
            pkey = this.retrievePublicKey(request);
        }
        return pkey;
    }

    protected boolean doEncryption(RequestContext request, Object arg) {
        return arg != null && arg instanceof RSAPublicKey;
    }

    protected Object initArg(RequestContext request) {
        return this.getPublicKey(request);
    }

    protected PublicKey retrievePublicKey(RequestContext request) {
        X509Certificate[] cert = this.getCerts(request);
        return cert != null ? cert[0].getPublicKey() : null;
    }

    protected EncryptionOptions initEncryptionOptions(RequestContext request, ResponseContext response, Encryption enc, Object arg) {
        try {
            EncryptionOptions options = enc.getDefaultEncryptionOptions();
            options.setDataEncryptionKey(KeyHelper.generateKey("AES"));
            options.setKeyEncryptionKey((PublicKey)arg);
            options.setKeyCipherAlgorithm("http://www.w3.org/2001/04/xmlenc#rsa-1_5");
            options.setIncludeKeyInfo(true);
            return options;
        }
        catch (Exception e) {
            return null;
        }
    }
}

