/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.interactive.form;

import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.PDSeedValue;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.PDSignature;
import org.apache.pdfbox.pdmodel.interactive.form.PDAcroForm;
import org.apache.pdfbox.pdmodel.interactive.form.PDField;

public class PDSignatureField
extends PDField {
    public PDSignatureField(PDAcroForm theAcroForm, COSDictionary field) throws IOException {
        super(theAcroForm, field);
        this.getDictionary().setItem(COSName.TYPE, (COSBase)COSName.ANNOT);
        this.getDictionary().setName(COSName.SUBTYPE, "Widget");
    }

    public PDSignatureField(PDAcroForm theAcroForm) throws IOException {
        super(theAcroForm);
        this.getDictionary().setItem(COSName.FT, (COSBase)COSName.SIG);
        this.getWidget().setLocked(true);
        this.getWidget().setPrinted(true);
        this.setPartialName(this.generatePartialName());
        this.getDictionary().setItem(COSName.TYPE, (COSBase)COSName.ANNOT);
        this.getDictionary().setName(COSName.SUBTYPE, "Widget");
    }

    private String generatePartialName() throws IOException {
        PDAcroForm acroForm = this.getAcroForm();
        List fields = acroForm.getFields();
        String fieldName = "Signature";
        int i = 1;
        HashSet<String> sigNames = new HashSet<String>();
        for (Object object : fields) {
            if (!(object instanceof PDSignatureField)) continue;
            sigNames.add(((PDSignatureField)object).getPartialName());
        }
        while (sigNames.contains(fieldName + i)) {
            ++i;
        }
        return fieldName + i;
    }

    @Deprecated
    public void setValue(String value) throws IOException {
        throw new RuntimeException("Can't set signature as String, use setSignature(PDSignature) instead");
    }

    @Deprecated
    public String getValue() throws IOException {
        throw new RuntimeException("Can't get signature as String, use getSignature() instead.");
    }

    public String toString() {
        return "PDSignature";
    }

    public void setSignature(PDSignature value) {
        this.getDictionary().setItem(COSName.V, (COSObjectable)value);
    }

    public PDSignature getSignature() {
        COSBase dictionary = this.getDictionary().getDictionaryObject(COSName.V);
        if (dictionary == null) {
            return null;
        }
        return new PDSignature((COSDictionary)dictionary);
    }

    public PDSeedValue getSeedValue() {
        COSDictionary dict = (COSDictionary)this.getDictionary().getDictionaryObject(COSName.SV);
        PDSeedValue sv = null;
        if (dict != null) {
            sv = new PDSeedValue(dict);
        }
        return sv;
    }

    public void setSeedValue(PDSeedValue sv) {
        if (sv != null) {
            this.getDictionary().setItem(COSName.SV, sv.getCOSObject());
        }
    }
}

