/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.random;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.math.MathRuntimeException;
import org.apache.commons.math.random.EmpiricalDistribution;
import org.apache.commons.math.random.RandomData;
import org.apache.commons.math.random.RandomDataImpl;
import org.apache.commons.math.stat.descriptive.StatisticalSummary;
import org.apache.commons.math.stat.descriptive.SummaryStatistics;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EmpiricalDistributionImpl
implements Serializable,
EmpiricalDistribution {
    private static final long serialVersionUID = 5729073523949762654L;
    private List<SummaryStatistics> binStats = null;
    private SummaryStatistics sampleStats = null;
    private int binCount = 1000;
    private boolean loaded = false;
    private double[] upperBounds = null;
    private RandomData randomData = new RandomDataImpl();

    public EmpiricalDistributionImpl() {
        this.binStats = new ArrayList<SummaryStatistics>();
    }

    public EmpiricalDistributionImpl(int binCount) {
        this.binCount = binCount;
        this.binStats = new ArrayList<SummaryStatistics>();
    }

    @Override
    public void load(double[] in) {
        ArrayDataAdapter da = new ArrayDataAdapter(in);
        try {
            ((DataAdapter)da).computeStats();
            this.fillBinStats(in);
        }
        catch (Exception e) {
            throw new MathRuntimeException(e);
        }
        this.loaded = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void load(URL url) throws IOException {
        BufferedReader in = new BufferedReader(new InputStreamReader(url.openStream()));
        try {
            StreamDataAdapter da = new StreamDataAdapter(in);
            try {
                ((DataAdapter)da).computeStats();
            }
            catch (IOException ioe) {
                throw ioe;
            }
            catch (RuntimeException rte) {
                throw rte;
            }
            catch (Exception e) {
                throw MathRuntimeException.createIOException(e);
            }
            if (this.sampleStats.getN() == 0L) {
                throw MathRuntimeException.createEOFException("URL {0} contains no data", url);
            }
            in = new BufferedReader(new InputStreamReader(url.openStream()));
            this.fillBinStats(in);
            this.loaded = true;
        }
        finally {
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void load(File file) throws IOException {
        BufferedReader in = new BufferedReader(new FileReader(file));
        try {
            StreamDataAdapter da = new StreamDataAdapter(in);
            try {
                ((DataAdapter)da).computeStats();
            }
            catch (IOException ioe) {
                throw ioe;
            }
            catch (RuntimeException rte) {
                throw rte;
            }
            catch (Exception e) {
                throw MathRuntimeException.createIOException(e);
            }
            in = new BufferedReader(new FileReader(file));
            this.fillBinStats(in);
            this.loaded = true;
        }
        finally {
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
    }

    private void fillBinStats(Object in) throws IOException {
        int i;
        double min = this.sampleStats.getMin();
        double max = this.sampleStats.getMax();
        double delta = (max - min) / Double.valueOf(this.binCount);
        double[] binUpperBounds = new double[this.binCount];
        binUpperBounds[0] = min + delta;
        for (i = 1; i < this.binCount - 1; ++i) {
            binUpperBounds[i] = binUpperBounds[i - 1] + delta;
        }
        binUpperBounds[this.binCount - 1] = max;
        if (!this.binStats.isEmpty()) {
            this.binStats.clear();
        }
        for (i = 0; i < this.binCount; ++i) {
            SummaryStatistics stats = new SummaryStatistics();
            this.binStats.add(i, stats);
        }
        DataAdapterFactory aFactory = new DataAdapterFactory();
        DataAdapter da = aFactory.getAdapter(in);
        try {
            da.computeBinStats(min, delta);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception e) {
            throw MathRuntimeException.createIOException(e);
        }
        this.upperBounds = new double[this.binCount];
        this.upperBounds[0] = (double)this.binStats.get(0).getN() / (double)this.sampleStats.getN();
        for (int i2 = 1; i2 < this.binCount - 1; ++i2) {
            this.upperBounds[i2] = this.upperBounds[i2 - 1] + (double)this.binStats.get(i2).getN() / (double)this.sampleStats.getN();
        }
        this.upperBounds[this.binCount - 1] = 1.0;
    }

    private int findBin(double min, double value, double delta) {
        return Math.min(Math.max((int)Math.ceil((value - min) / delta) - 1, 0), this.binCount - 1);
    }

    @Override
    public double getNextValue() throws IllegalStateException {
        if (!this.loaded) {
            throw MathRuntimeException.createIllegalStateException("distribution not loaded", new Object[0]);
        }
        double x = Math.random();
        for (int i = 0; i < this.binCount; ++i) {
            SummaryStatistics stats;
            if (!(x <= this.upperBounds[i]) || (stats = this.binStats.get(i)).getN() <= 0L) continue;
            if (stats.getStandardDeviation() > 0.0) {
                return this.randomData.nextGaussian(stats.getMean(), stats.getStandardDeviation());
            }
            return stats.getMean();
        }
        throw new MathRuntimeException("no bin selected", new Object[0]);
    }

    @Override
    public StatisticalSummary getSampleStats() {
        return this.sampleStats;
    }

    @Override
    public int getBinCount() {
        return this.binCount;
    }

    @Override
    public List<SummaryStatistics> getBinStats() {
        return this.binStats;
    }

    @Override
    public double[] getUpperBounds() {
        int len = this.upperBounds.length;
        double[] out = new double[len];
        System.arraycopy(this.upperBounds, 0, out, 0, len);
        return out;
    }

    @Override
    public boolean isLoaded() {
        return this.loaded;
    }

    private class ArrayDataAdapter
    extends DataAdapter {
        private double[] inputArray;

        public ArrayDataAdapter(double[] in) {
            this.inputArray = in;
        }

        public void computeStats() throws IOException {
            EmpiricalDistributionImpl.this.sampleStats = new SummaryStatistics();
            for (int i = 0; i < this.inputArray.length; ++i) {
                EmpiricalDistributionImpl.this.sampleStats.addValue(this.inputArray[i]);
            }
        }

        public void computeBinStats(double min, double delta) throws IOException {
            for (int i = 0; i < this.inputArray.length; ++i) {
                SummaryStatistics stats = (SummaryStatistics)EmpiricalDistributionImpl.this.binStats.get(EmpiricalDistributionImpl.this.findBin(min, this.inputArray[i], delta));
                stats.addValue(this.inputArray[i]);
            }
        }
    }

    private class StreamDataAdapter
    extends DataAdapter {
        private BufferedReader inputStream;

        public StreamDataAdapter(BufferedReader in) {
            this.inputStream = in;
        }

        public void computeBinStats(double min, double delta) throws IOException {
            String str = null;
            double val = 0.0;
            while ((str = this.inputStream.readLine()) != null) {
                val = Double.parseDouble(str);
                SummaryStatistics stats = (SummaryStatistics)EmpiricalDistributionImpl.this.binStats.get(EmpiricalDistributionImpl.this.findBin(min, val, delta));
                stats.addValue(val);
            }
            this.inputStream.close();
            this.inputStream = null;
        }

        public void computeStats() throws IOException {
            String str = null;
            double val = 0.0;
            EmpiricalDistributionImpl.this.sampleStats = new SummaryStatistics();
            while ((str = this.inputStream.readLine()) != null) {
                val = Double.valueOf(str);
                EmpiricalDistributionImpl.this.sampleStats.addValue(val);
            }
            this.inputStream.close();
            this.inputStream = null;
        }
    }

    private class DataAdapterFactory {
        private DataAdapterFactory() {
        }

        public DataAdapter getAdapter(Object in) {
            if (in instanceof BufferedReader) {
                BufferedReader inputStream = (BufferedReader)in;
                return new StreamDataAdapter(inputStream);
            }
            if (in instanceof double[]) {
                double[] inputArray = (double[])in;
                return new ArrayDataAdapter(inputArray);
            }
            throw MathRuntimeException.createIllegalArgumentException("input data comes from unsupported datasource: {0}, supported sources: {1}, {2}", in.getClass().getName(), BufferedReader.class.getName(), double[].class.getName());
        }
    }

    private abstract class DataAdapter {
        private DataAdapter() {
        }

        public abstract void computeBinStats(double var1, double var3) throws Exception;

        public abstract void computeStats() throws Exception;
    }
}

