/*
 * Decompiled with CFR 0.152.
 */
package com.browseengine.bobo.facets.impl;

import com.browseengine.bobo.api.FacetIterator;
import com.browseengine.bobo.facets.data.TermValueList;
import com.browseengine.bobo.util.BigSegmentedArray;

public class DefaultFacetIterator
extends FacetIterator {
    private TermValueList _valList;
    private BigSegmentedArray _count;
    private int _countlength;
    private int _index;
    private int _lastIndex;

    public DefaultFacetIterator(TermValueList valList, BigSegmentedArray counts, int countlength, boolean zeroBased) {
        this._valList = valList;
        this._count = counts;
        this._countlength = countlength;
        this._index = -1;
        this._lastIndex = this._countlength - 1;
        if (!zeroBased) {
            ++this._index;
        }
        this.facet = null;
        this.count = 0;
    }

    @Override
    public boolean hasNext() {
        return this._index < this._lastIndex;
    }

    @Override
    public Comparable next() {
        ++this._index;
        this.facet = (Comparable)this._valList.getRawValue(this._index);
        this.count = this._count.get(this._index);
        return this.format(this.facet);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove() method not supported for Facet Iterators");
    }

    @Override
    public Comparable next(int minHits) {
        while (++this._index < this._countlength) {
            if (this._count.get(this._index) < minHits) continue;
            this.facet = (Comparable)this._valList.getRawValue(this._index);
            this.count = this._count.get(this._index);
            return this.format(this.facet);
        }
        this.facet = null;
        this.count = 0;
        return null;
    }

    @Override
    public String format(Object val) {
        return this._valList.format(val);
    }
}

