/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.io.IOException;
import org.hsqldb.RowAVL;
import org.hsqldb.TableBase;
import org.hsqldb.index.NodeAVL;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.rowio.RowInputInterface;
import org.hsqldb.rowio.RowOutputInterface;

public class RowAVLDiskData
extends RowAVL {
    PersistentStore store;
    int accessCount;
    boolean hasDataChanged;
    int storageSize;

    public RowAVLDiskData(PersistentStore store, TableBase t, Object[] o) {
        super(t, o);
        this.setNewNodes(store);
        this.hasDataChanged = true;
        this.store = store;
    }

    public RowAVLDiskData(PersistentStore store, TableBase t, RowInputInterface in) throws IOException {
        super(t, null);
        this.setNewNodes(store);
        this.position = in.getPos();
        this.storageSize = in.getSize();
        this.rowData = in.readData(this.table.getColumnTypes());
        this.hasDataChanged = false;
        this.store = store;
    }

    public static Object[] getRowData(TableBase t, RowInputInterface in) throws IOException {
        return in.readData(t.getColumnTypes());
    }

    public void setData(Object[] data) {
        this.rowData = data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] getData() {
        Object[] data = this.rowData;
        if (data == null) {
            this.store.writeLock();
            try {
                this.store.get(this, false);
                data = this.rowData;
                if (data == null) {
                    this.store.get(this, false);
                    data = this.rowData;
                }
                Object var3_2 = null;
                this.store.writeUnlock();
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.store.writeUnlock();
                throw throwable;
            }
        } else {
            ++this.accessCount;
        }
        return data;
    }

    public void setNewNodes(PersistentStore store) {
        int index = store.getAccessorKeys().length;
        NodeAVL n = this.nPrimaryNode = new NodeAVL(this);
        for (int i = 1; i < index; ++i) {
            n = n.nNext = new NodeAVL(this);
        }
    }

    public NodeAVL insertNode(int index) {
        NodeAVL backnode = this.getNode(index - 1);
        NodeAVL newnode = new NodeAVL(this);
        newnode.nNext = backnode.nNext;
        backnode.nNext = newnode;
        return newnode;
    }

    void setPrimaryNode(NodeAVL primary) {
        this.nPrimaryNode = primary;
    }

    public int getRealSize(RowOutputInterface out) {
        return out.getSize(this);
    }

    public void write(RowOutputInterface out) {
        out.writeSize(this.storageSize);
        out.writeData(this, this.table.colTypes);
        out.writeEnd();
        this.hasDataChanged = false;
    }

    public synchronized void setChanged(boolean changed) {
        this.hasDataChanged = changed;
    }

    public boolean hasChanged() {
        return this.hasDataChanged;
    }

    public void updateAccessCount(int count) {
        this.accessCount = count;
    }

    public int getAccessCount() {
        return this.accessCount;
    }

    public int getStorageSize() {
        return this.storageSize;
    }

    public void setStorageSize(int size) {
        this.storageSize = size;
    }

    public void setPos(int pos) {
        this.position = pos;
    }

    public boolean isMemory() {
        return true;
    }

    public boolean equals(Object obj) {
        return obj == this;
    }

    public boolean isInMemory() {
        return true;
    }

    public boolean isKeepInMemory() {
        return false;
    }

    public boolean keepInMemory(boolean keep) {
        return true;
    }

    public void setInMemory(boolean in) {
        if (!in) {
            this.rowData = null;
        }
    }
}

