/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools.sourceformatter;

import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.IOException;
import java.io.Reader;
import java.util.List;

public class JavaTerm {
    private String _content;
    private int _lineCount;
    private String _name;
    private List<String> _parameterTypes;
    private int _type;

    public JavaTerm(String name, int type, List<String> parameterTypes, String content, int lineCount) {
        this._name = name;
        this._type = type;
        this._parameterTypes = parameterTypes;
        this._content = content;
        this._lineCount = lineCount;
    }

    public String getContent() {
        return this._content;
    }

    public int getLineCount() {
        return this._lineCount;
    }

    public String getName() {
        return this._name;
    }

    public List<String> getParameterTypes() {
        return this._parameterTypes;
    }

    public int getType() {
        return this._type;
    }

    public void setContent(String content) {
        this._content = content;
    }

    public void setLineCount(int lineCount) {
        this._lineCount = lineCount;
    }

    public void setName(String name) {
        this._name = name;
    }

    public void setParameterTypes(List<String> parameterTypes) {
        this._parameterTypes = parameterTypes;
    }

    public void setType(int type) {
        this._type = type;
    }

    public void sortAnnotations() throws IOException {
        UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader((Reader)new UnsyncStringReader(this._content));
        String line = null;
        String annotation = "";
        String previousAnnotation = "";
        while ((line = unsyncBufferedReader.readLine()) != null) {
            if (line.equals("\t}")) {
                return;
            }
            if (StringUtil.count((String)line, (String)"\t") == 1) {
                if (Validator.isNotNull((String)previousAnnotation) && previousAnnotation.compareTo(annotation) > 0) {
                    this._content = StringUtil.replaceFirst((String)this._content, (String)previousAnnotation, (String)annotation);
                    this._content = StringUtil.replaceLast((String)this._content, (String)annotation, (String)previousAnnotation);
                    return;
                }
                if (line.startsWith("\t@")) {
                    if (Validator.isNotNull((String)annotation)) {
                        previousAnnotation = annotation;
                    }
                    annotation = String.valueOf(line) + "\n";
                    continue;
                }
                annotation = "";
                continue;
            }
            if (Validator.isNull((String)annotation)) {
                return;
            }
            annotation = String.valueOf(annotation) + line + "\n";
        }
    }
}

