/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.plugin;

import com.liferay.portal.kernel.plugin.License;
import com.liferay.portal.kernel.plugin.PluginPackage;
import com.liferay.portal.kernel.search.BaseIndexer;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.BooleanQueryFactoryUtil;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.DocumentImpl;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchEngineUtil;
import com.liferay.portal.kernel.search.Summary;
import com.liferay.portal.kernel.search.TermQuery;
import com.liferay.portal.kernel.search.TermQueryFactoryUtil;
import com.liferay.portal.kernel.util.Accessor;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.plugin.ModuleId;
import com.liferay.portal.plugin.PluginPackageUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.portlet.PortletURL;

public class PluginPackageIndexer
extends BaseIndexer {
    public static final String[] CLASS_NAMES = new String[]{PluginPackage.class.getName()};
    public static final String PORTLET_ID = "PluginPackageIndexer";

    public PluginPackageIndexer() {
        this.setCommitImmediately(true);
        this.setStagingAware(false);
    }

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    public String getPortletId() {
        return PORTLET_ID;
    }

    protected void doDelete(Object obj) throws Exception {
        PluginPackage pluginPackage = (PluginPackage)obj;
        this.deleteDocument(0L, pluginPackage.getModuleId());
    }

    protected Document doGetDocument(Object obj) throws Exception {
        PluginPackage pluginPackage = (PluginPackage)obj;
        DocumentImpl document = new DocumentImpl();
        document.addUID(PORTLET_ID, pluginPackage.getModuleId());
        document.addKeyword("companyId", 0L);
        StringBundler sb = new StringBundler(7);
        sb.append(pluginPackage.getAuthor());
        sb.append(" ");
        String longDescription = HtmlUtil.extractText((String)pluginPackage.getLongDescription());
        sb.append(longDescription);
        sb.append(" ");
        sb.append(pluginPackage.getName());
        sb.append(" ");
        String shortDescription = HtmlUtil.extractText((String)pluginPackage.getShortDescription());
        sb.append(shortDescription);
        document.addText("content", sb.toString());
        document.addKeyword("entryClassName", PluginPackage.class.getName());
        ModuleId moduleIdObj = ModuleId.getInstance(pluginPackage.getModuleId());
        document.addKeyword("groupId", moduleIdObj.getGroupId());
        document.addDate("modified", pluginPackage.getModifiedDate());
        document.addKeyword("portletId", PORTLET_ID);
        String[] statusAndInstalledVersion = PluginPackageUtil.getStatusAndInstalledVersion(pluginPackage);
        document.addKeyword("status", statusAndInstalledVersion[0]);
        document.addText("title", pluginPackage.getName());
        document.addKeyword("artifactId", moduleIdObj.getArtifactId());
        document.addText("author", pluginPackage.getAuthor());
        document.addText("changeLog", pluginPackage.getChangeLog());
        document.addKeyword("installedVersion", statusAndInstalledVersion[1]);
        List licenses = pluginPackage.getLicenses();
        document.addKeyword("license", StringUtil.split((String)ListUtil.toString((List)licenses, (Accessor)License.NAME_ACCESSOR)));
        document.addText("longDescription", longDescription);
        document.addKeyword("moduleId", pluginPackage.getModuleId());
        boolean osiLicense = false;
        int i2 = 0;
        while (i2 < licenses.size()) {
            License license = (License)licenses.get(i2);
            if (license.isOsiApproved()) {
                osiLicense = true;
                break;
            }
            ++i2;
        }
        document.addKeyword("osi-approved-license", osiLicense);
        document.addText("pageURL", pluginPackage.getPageURL());
        document.addKeyword("repositoryURL", pluginPackage.getRepositoryURL());
        document.addText("shortDescription", shortDescription);
        List tags = pluginPackage.getTags();
        document.addKeyword("tag", tags.toArray(new String[tags.size()]));
        List types = pluginPackage.getTypes();
        document.addKeyword("type", types.toArray(new String[types.size()]));
        document.addKeyword("version", pluginPackage.getVersion());
        return document;
    }

    protected Summary doGetSummary(Document document, Locale locale, String snippet, PortletURL portletURL) {
        String title = document.get("title");
        String content = snippet;
        if (Validator.isNull((String)snippet)) {
            content = StringUtil.shorten((String)document.get("content"), (int)200);
        }
        String moduleId = document.get("moduleId");
        String repositoryURL = document.get("repositoryURL");
        portletURL.setParameter("struts_action", "/admin/view");
        portletURL.setParameter("tabs2", "repositories");
        portletURL.setParameter("moduleId", moduleId);
        portletURL.setParameter("repositoryURL", repositoryURL);
        return new Summary(title, content, portletURL);
    }

    protected void doReindex(Object obj) throws Exception {
        PluginPackage pluginPackage = (PluginPackage)obj;
        Document document = this.getDocument(pluginPackage);
        SearchEngineUtil.updateDocument((String)this.getSearchEngineId(), (long)0L, (Document)document, (boolean)this.isCommitImmediately());
    }

    protected void doReindex(String className, long classPK) throws Exception {
    }

    protected void doReindex(String[] ids) throws Exception {
        SearchEngineUtil.deletePortletDocuments((String)this.getSearchEngineId(), (long)0L, (String)PORTLET_ID, (boolean)this.isCommitImmediately());
        ArrayList<Document> documents = new ArrayList<Document>();
        for (PluginPackage pluginPackage : PluginPackageUtil.getAllAvailablePluginPackages()) {
            Document document = this.getDocument(pluginPackage);
            documents.add(document);
        }
        SearchEngineUtil.updateDocuments((String)this.getSearchEngineId(), (long)0L, documents, (boolean)this.isCommitImmediately());
    }

    protected String getPortletId(SearchContext searchContext) {
        return PORTLET_ID;
    }

    protected void postProcessFullQuery(BooleanQuery fullQuery, SearchContext searchContext) throws Exception {
        String status;
        String license;
        String repositoryURL;
        String tag;
        String type = (String)((Object)searchContext.getAttribute("type"));
        if (Validator.isNotNull((String)type)) {
            BooleanQuery searchQuery = BooleanQueryFactoryUtil.create((SearchContext)searchContext);
            searchQuery.addRequiredTerm("type", type);
            fullQuery.add((Query)searchQuery, BooleanClauseOccur.MUST);
        }
        if (Validator.isNotNull((String)(tag = (String)((Object)searchContext.getAttribute("tag"))))) {
            BooleanQuery searchQuery = BooleanQueryFactoryUtil.create((SearchContext)searchContext);
            searchQuery.addExactTerm("tag", tag);
            fullQuery.add((Query)searchQuery, BooleanClauseOccur.MUST);
        }
        if (Validator.isNotNull((String)(repositoryURL = (String)((Object)searchContext.getAttribute("repositoryURL"))))) {
            BooleanQuery searchQuery = BooleanQueryFactoryUtil.create((SearchContext)searchContext);
            TermQuery query = TermQueryFactoryUtil.create((SearchContext)searchContext, (String)"repositoryURL", (String)repositoryURL);
            searchQuery.add((Query)query, BooleanClauseOccur.SHOULD);
            fullQuery.add((Query)searchQuery, BooleanClauseOccur.MUST);
        }
        if (Validator.isNotNull((String)(license = (String)((Object)searchContext.getAttribute("license"))))) {
            BooleanQuery searchQuery = BooleanQueryFactoryUtil.create((SearchContext)searchContext);
            searchQuery.addExactTerm("license", license);
            fullQuery.add((Query)searchQuery, BooleanClauseOccur.MUST);
        }
        if (Validator.isNull((String)(status = (String)((Object)searchContext.getAttribute("status")))) || status.equals("all")) {
            return;
        }
        BooleanQuery searchQuery = BooleanQueryFactoryUtil.create((SearchContext)searchContext);
        if (status.equals("notInstalledOrOlderVersionInstalled")) {
            searchQuery.addExactTerm("status", "notInstalled");
            searchQuery.addExactTerm("status", "olderVersionInstalled");
        } else {
            searchQuery.addExactTerm("status", status);
        }
        fullQuery.add((Query)searchQuery, BooleanClauseOccur.MUST);
    }
}

