/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.calendar.service.permission;

import com.liferay.calendar.model.CalendarResource;
import com.liferay.calendar.service.CalendarResourceLocalServiceUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.security.permission.PermissionChecker;

public class CalendarResourcePermission {
    public static void check(PermissionChecker permissionChecker, CalendarResource calendarResource, String actionId) throws PortalException {
        if (!CalendarResourcePermission.contains(permissionChecker, calendarResource, actionId)) {
            throw new PrincipalException();
        }
    }

    public static void check(PermissionChecker permissionChecker, long calendarResourceId, String actionId) throws PortalException, SystemException {
        if (!CalendarResourcePermission.contains(permissionChecker, calendarResourceId, actionId)) {
            throw new PrincipalException();
        }
    }

    public static boolean contains(PermissionChecker permissionChecker, CalendarResource calendarResource, String actionId) {
        if (permissionChecker.hasOwnerPermission(calendarResource.getCompanyId(), CalendarResource.class.getName(), calendarResource.getCalendarResourceId(), calendarResource.getUserId(), actionId)) {
            return true;
        }
        return permissionChecker.hasPermission(calendarResource.getGroupId(), CalendarResource.class.getName(), calendarResource.getCalendarResourceId(), actionId);
    }

    public static boolean contains(PermissionChecker permissionChecker, long calendarResourceId, String actionId) throws PortalException, SystemException {
        CalendarResource calendarResource = CalendarResourceLocalServiceUtil.getCalendarResource(calendarResourceId);
        return CalendarResourcePermission.contains(permissionChecker, calendarResource, actionId);
    }
}

