/*
 * Decompiled with CFR 0.152.
 */
package jodd.petite.resolver;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import jodd.introspector.ClassDescriptor;
import jodd.introspector.ClassIntrospector;
import jodd.petite.BeanDefinition;
import jodd.petite.ProviderDefinition;
import jodd.petite.meta.PetiteProvider;
import jodd.util.StringUtil;

public class ProviderResolver {
    public ProviderDefinition[] resolve(BeanDefinition beanDefinition) {
        Class type = beanDefinition.getType();
        ClassDescriptor cd = ClassIntrospector.lookup(type);
        Method[] methods = cd.getAllMethods(true);
        ArrayList<ProviderDefinition> list = new ArrayList<ProviderDefinition>();
        for (Method method : methods) {
            PetiteProvider petiteProvider = method.getAnnotation(PetiteProvider.class);
            if (petiteProvider == null) continue;
            String providerName = petiteProvider.value();
            if (StringUtil.isBlank(providerName) && (providerName = method.getName()).endsWith("Provider")) {
                providerName = StringUtil.substring(providerName, 0, -8);
            }
            ProviderDefinition providerDefinition = Modifier.isStatic(method.getModifiers()) ? new ProviderDefinition(providerName, method) : new ProviderDefinition(providerName, beanDefinition.getName(), method);
            list.add(providerDefinition);
        }
        ProviderDefinition[] providers = list.isEmpty() ? ProviderDefinition.EMPTY : list.toArray(new ProviderDefinition[list.size()]);
        return providers;
    }
}

