/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ecs;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Hashtable;
import org.apache.ecs.ECSDefaults;
import org.apache.ecs.Element;
import org.apache.ecs.Filter;
import org.apache.ecs.filter.CharacterFilter;

public abstract class GenericElement
implements Element,
Serializable {
    private static Filter _defaultFilter = new CharacterFilter();
    private Filter filter = _defaultFilter;
    private int position = ECSDefaults.getDefaultPosition();
    private boolean filter_state = ECSDefaults.getDefaultFilterState();
    private boolean pretty_print = ECSDefaults.getDefaultPrettyPrint();
    private static final String VERSION = "1.4.2";
    private int case_type = ECSDefaults.getDefaultCaseType();
    private Hashtable element = new Hashtable(4);
    private boolean end_element = ECSDefaults.getDefaultEndElement();
    private String codeset = ECSDefaults.getDefaultCodeset();
    private char begin_start_modifier = ECSDefaults.getDefaultBeginStartModifier();
    private char end_start_modifier = ECSDefaults.getDefaultEndStartModifier();
    private char begin_end_modifier = ECSDefaults.getDefaultBeginEndModifier();
    private char end_end_modifier = ECSDefaults.getDefaultEndEndModifier();
    private boolean start_modifier_defined = false;
    private boolean begin_start_modifier_defined = false;
    private boolean end_start_modifier_defined = false;
    private boolean begin_end_modifier_defined = false;
    private boolean end_end_modifier_defined = false;
    private boolean end_modifier_defined = false;
    protected int tabLevel = 0;
    private char start_tag = ECSDefaults.getDefaultStartTag();
    private char end_tag = ECSDefaults.getDefaultEndTag();
    private String __text = new String();
    private String element_type = new String();

    public abstract Element addElementToRegistry(String var1);

    public abstract Element addElementToRegistry(Element var1);

    protected String alterCase(String string) {
        switch (this.getCase()) {
            case 1: {
                return string.toUpperCase();
            }
            case 2: {
                return string.toLowerCase();
            }
        }
        return string;
    }

    public String createEndTag() {
        this.setEndStartModifier('/');
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getStartTagChar());
        if (this.getEndStartModifierDefined()) {
            stringBuffer.append(this.getEndStartModifier());
        }
        stringBuffer.append(this.getElementType());
        if (this.getEndEndModifierDefined()) {
            stringBuffer.append(this.getEndEndModifier());
        }
        stringBuffer.append(this.getEndTagChar());
        return stringBuffer.toString();
    }

    public String createStartTag() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getStartTagChar());
        if (this.getBeginStartModifierDefined()) {
            stringBuffer.append(this.getBeginStartModifier());
        }
        stringBuffer.append(this.getElementType());
        if (this.getBeginEndModifierDefined()) {
            stringBuffer.append(this.getBeginEndModifier());
        }
        stringBuffer.append(this.getEndTagChar());
        return stringBuffer.toString();
    }

    public char getBeginEndModifier() {
        return this.begin_end_modifier;
    }

    protected boolean getBeginEndModifierDefined() {
        return this.begin_end_modifier_defined;
    }

    public char getBeginStartModifier() {
        return this.begin_start_modifier;
    }

    protected boolean getBeginStartModifierDefined() {
        return this.begin_start_modifier_defined;
    }

    public int getCase() {
        return this.case_type;
    }

    public String getCodeSet() {
        return this.codeset;
    }

    protected Hashtable getElementHashEntry() {
        return this.element;
    }

    public String getElementType() {
        return this.element_type;
    }

    public char getEndEndModifier() {
        return this.end_end_modifier;
    }

    protected boolean getEndEndModifierDefined() {
        return this.end_end_modifier_defined;
    }

    public char getEndStartModifier() {
        return this.end_start_modifier;
    }

    protected boolean getEndStartModifierDefined() {
        return this.end_start_modifier_defined;
    }

    public char getEndTagChar() {
        return this.end_tag;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public boolean getFilterState() {
        return this.filter_state;
    }

    public boolean getNeedClosingTag() {
        return this.end_element;
    }

    public boolean getNeedLineBreak() {
        return true;
    }

    public boolean getPrettyPrint() {
        return this.pretty_print;
    }

    public char getStartTagChar() {
        return this.start_tag;
    }

    public int getTabLevel() {
        return this.tabLevel;
    }

    public int getTagPosition() {
        return this.position;
    }

    public String getTagText() {
        return this.__text;
    }

    public String getVersion() {
        return VERSION;
    }

    public void output(OutputStream outputStream) {
        String string = null;
        string = this.getCodeSet() != null ? this.getCodeSet() : "UTF-16BE";
        try {
            outputStream.write(this.createStartTag().getBytes(string));
            if (this.getFilterState()) {
                outputStream.write(this.getFilter().process(this.getTagText()).getBytes(string));
            } else {
                outputStream.write(this.getTagText().getBytes(string));
            }
            if (this.getNeedClosingTag()) {
                outputStream.write(this.createEndTag().getBytes(string));
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace(new PrintWriter(outputStream));
        }
        catch (IOException iOException) {
            iOException.printStackTrace(new PrintWriter(outputStream));
        }
    }

    public void output(PrintWriter printWriter) {
        printWriter.write(this.createStartTag());
        if (this.getFilterState()) {
            printWriter.write(this.getFilter().process(this.getTagText()));
        } else {
            printWriter.write(this.getTagText());
        }
        if (this.getNeedClosingTag()) {
            printWriter.write(this.createEndTag());
        }
    }

    public void output(Writer writer) {
        this.output(new PrintWriter(writer));
    }

    protected void putTabs(int n, OutputStream outputStream) throws IOException {
        int n2 = 0;
        while (n2 < n) {
            outputStream.write(9);
            ++n2;
        }
    }

    protected void putTabs(int n, PrintWriter printWriter) {
        int n2 = 0;
        while (n2 < n) {
            printWriter.print('\t');
            ++n2;
        }
    }

    public abstract boolean registryHasElement(String var1);

    public abstract boolean registryHasElement(Element var1);

    public Element removeBeginEndModifier() {
        this.setBeginEndModifierDefined(false);
        return this;
    }

    public Element removeBeginStartModifier() {
        this.setBeginStartModifierDefined(false);
        return this;
    }

    public abstract Element removeElementFromRegistry(String var1);

    public abstract Element removeElementFromRegistry(Element var1);

    public Element removeEndEndModifier() {
        this.setEndEndModifierDefined(false);
        return this;
    }

    public Element removeEndStartModifier() {
        this.setEndStartModifierDefined(false);
        return this;
    }

    public Element setBeginEndModifier(char c) {
        this.begin_end_modifier = c;
        this.setBeginEndModifierDefined(true);
        return this;
    }

    private void setBeginEndModifierDefined(boolean bl) {
        this.begin_end_modifier_defined = bl;
    }

    public Element setBeginModifier(char c) {
        this.setBeginStartModifier(c);
        this.setBeginEndModifier(c);
        this.setBeginStartModifierDefined(true);
        this.setBeginEndModifierDefined(true);
        return this;
    }

    public Element setBeginModifier(char c, char c2) {
        this.begin_start_modifier = c;
        this.begin_end_modifier = c2;
        this.setBeginStartModifierDefined(true);
        this.setBeginEndModifierDefined(true);
        return this;
    }

    public Element setBeginStartModifier(char c) {
        this.begin_start_modifier = c;
        this.setBeginStartModifierDefined(true);
        return this;
    }

    private void setBeginStartModifierDefined(boolean bl) {
        this.begin_start_modifier_defined = bl;
    }

    public void setCase(int n) {
        this.case_type = n;
    }

    public void setCodeSet(String string) {
        this.codeset = string;
    }

    public void setElementType(String string) {
        this.element_type = string;
    }

    public Element setEndEndModifier(char c) {
        this.end_end_modifier = c;
        this.setEndEndModifierDefined(true);
        return this;
    }

    private void setEndEndModifierDefined(boolean bl) {
        this.end_end_modifier_defined = bl;
    }

    public Element setEndModifier(char c) {
        this.setEndStartModifier(c);
        this.setEndEndModifier(c);
        this.setEndStartModifierDefined(true);
        this.setEndEndModifierDefined(true);
        return this;
    }

    public Element setEndModifier(char c, char c2) {
        this.end_start_modifier = c;
        this.end_end_modifier = c2;
        this.setEndStartModifierDefined(true);
        this.setEndEndModifierDefined(true);
        return this;
    }

    public Element setEndStartModifier(char c) {
        this.end_start_modifier = c;
        this.setEndStartModifierDefined(true);
        return this;
    }

    private void setEndStartModifierDefined(boolean bl) {
        this.end_start_modifier_defined = bl;
    }

    public void setEndTagChar(char c) {
        this.end_tag = c;
    }

    public void setFilter(Filter filter) {
        this.filter = filter;
    }

    public Element setFilterState(boolean bl) {
        this.filter_state = bl;
        return this;
    }

    public void setNeedClosingTag(boolean bl) {
        this.end_element = bl;
    }

    public Element setPrettyPrint(boolean bl) {
        this.pretty_print = bl;
        return this;
    }

    public void setStartTagChar(char c) {
        this.start_tag = c;
    }

    public void setTabLevel(int n) {
        this.tabLevel = n;
    }

    public void setTagPosition(int n) {
        this.position = n;
    }

    public Element setTagText(String string) {
        this.__text = string;
        return this;
    }

    public final String toString() {
        StringWriter stringWriter = new StringWriter();
        String string = null;
        try {
            this.output(stringWriter);
            stringWriter.flush();
            string = stringWriter.toString();
            stringWriter.close();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return string;
    }

    public final String toString(String string) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(byteArrayOutputStream);
        String string2 = null;
        try {
            this.output(bufferedOutputStream);
            bufferedOutputStream.flush();
            string2 = byteArrayOutputStream.toString(string);
            bufferedOutputStream.close();
            byteArrayOutputStream.close();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
        }
        catch (IOException iOException) {}
        return string2;
    }
}

