/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.shopping.action;

import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncPrintWriter;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.UnsyncPrintWriterPool;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextFactory;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.shopping.NoSuchOrderException;
import com.liferay.portlet.shopping.model.ShoppingOrder;
import com.liferay.portlet.shopping.service.ShoppingOrderLocalServiceUtil;
import com.liferay.portlet.shopping.util.ShoppingPreferences;
import com.liferay.portlet.shopping.util.ShoppingUtil;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class PayPalNotificationAction
extends Action {
    private static Log _log = LogFactoryUtil.getLog(PayPalNotificationAction.class);

    public ActionForward execute(ActionMapping actionMapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String invoice = null;
        try {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Receiving notification from PayPal");
            }
            String query = "cmd=_notify-validate";
            Enumeration enu = request.getParameterNames();
            while (enu.hasMoreElements()) {
                String name = (String)enu.nextElement();
                String value = request.getParameter(name);
                query = String.valueOf(query) + "&" + name + "=" + HttpUtil.encodeURL((String)value);
            }
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Sending response to PayPal " + query));
            }
            URL url = new URL("https://www.paypal.com/cgi-bin/webscr");
            URLConnection urlc = url.openConnection();
            urlc.setDoOutput(true);
            urlc.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            UnsyncPrintWriter pw = UnsyncPrintWriterPool.borrow((OutputStream)urlc.getOutputStream());
            pw.println(query);
            pw.close();
            UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader((Reader)new InputStreamReader(urlc.getInputStream()));
            String payPalStatus = unsyncBufferedReader.readLine();
            unsyncBufferedReader.close();
            String itemName = ParamUtil.getString((HttpServletRequest)request, (String)"item_name");
            String itemNumber = ParamUtil.getString((HttpServletRequest)request, (String)"item_number");
            invoice = ParamUtil.getString((HttpServletRequest)request, (String)"invoice");
            String txnId = ParamUtil.getString((HttpServletRequest)request, (String)"txn_id");
            String paymentStatus = ParamUtil.getString((HttpServletRequest)request, (String)"payment_status");
            double paymentGross = ParamUtil.getDouble((HttpServletRequest)request, (String)"mc_gross");
            String receiverEmail = ParamUtil.getString((HttpServletRequest)request, (String)"receiver_email");
            String payerEmail = ParamUtil.getString((HttpServletRequest)request, (String)"payer_email");
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Receiving response from PayPal");
                _log.debug((Object)("Item name " + itemName));
                _log.debug((Object)("Item number " + itemNumber));
                _log.debug((Object)("Invoice " + invoice));
                _log.debug((Object)("Transaction ID " + txnId));
                _log.debug((Object)("Payment status " + paymentStatus));
                _log.debug((Object)("Payment gross " + paymentGross));
                _log.debug((Object)("Receiver email " + receiverEmail));
                _log.debug((Object)("Payer email " + payerEmail));
            }
            if (payPalStatus.equals("VERIFIED") && this.validate(request)) {
                ServiceContext serviceContext = ServiceContextFactory.getInstance((HttpServletRequest)request);
                ShoppingOrderLocalServiceUtil.completeOrder((String)invoice, (String)txnId, (String)paymentStatus, (double)paymentGross, (String)receiverEmail, (String)payerEmail, (boolean)true, (ServiceContext)serviceContext);
            } else {
                payPalStatus.equals("INVALID");
            }
            return null;
        }
        catch (Exception e2) {
            PortalUtil.sendError((Exception)e2, (HttpServletRequest)request, (HttpServletResponse)response);
            return null;
        }
    }

    protected boolean validate(HttpServletRequest request) throws Exception {
        String ppInvoice = ParamUtil.getString((HttpServletRequest)request, (String)"invoice");
        ShoppingOrder order = ShoppingOrderLocalServiceUtil.getOrder((String)ppInvoice);
        ShoppingPreferences shoppingPrefs = ShoppingPreferences.getInstance(order.getCompanyId(), order.getGroupId());
        String ppReceiverEmail = ParamUtil.getString((HttpServletRequest)request, (String)"receiver_email");
        String payPalEmailAddress = shoppingPrefs.getPayPalEmailAddress();
        if (!payPalEmailAddress.equals(ppReceiverEmail)) {
            return false;
        }
        double ppGross = ParamUtil.getDouble((HttpServletRequest)request, (String)"mc_gross");
        double orderTotal = ShoppingUtil.calculateTotal(order);
        if (orderTotal != ppGross) {
            return false;
        }
        String ppCurrency = ParamUtil.getString((HttpServletRequest)request, (String)"mc_currency");
        String currencyId = shoppingPrefs.getCurrencyId();
        if (!currencyId.equals(ppCurrency)) {
            return false;
        }
        String ppTxnId = ParamUtil.getString((HttpServletRequest)request, (String)"txn_id");
        try {
            ShoppingOrderLocalServiceUtil.getPayPalTxnIdOrder((String)ppTxnId);
            return false;
        }
        catch (NoSuchOrderException noSuchOrderException) {
            return true;
        }
    }
}

