/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.dynamicdatalists.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.dynamicdatalists.model.DDLRecordSet;
import com.liferay.portlet.dynamicdatalists.service.base.DDLRecordSetServiceBaseImpl;
import com.liferay.portlet.dynamicdatalists.service.permission.DDLPermission;
import com.liferay.portlet.dynamicdatalists.service.permission.DDLRecordSetPermission;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class DDLRecordSetServiceImpl
extends DDLRecordSetServiceBaseImpl {
    public DDLRecordSet addRecordSet(long groupId, long ddmStructureId, String recordSetKey, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, int minDisplayRows, int scope, ServiceContext serviceContext) throws PortalException, SystemException {
        DDLPermission.check(this.getPermissionChecker(), groupId, "ADD_RECORD_SET");
        return this.ddlRecordSetLocalService.addRecordSet(this.getUserId(), groupId, ddmStructureId, recordSetKey, nameMap, descriptionMap, minDisplayRows, scope, serviceContext);
    }

    public void deleteRecordSet(long recordSetId) throws PortalException, SystemException {
        DDLRecordSetPermission.check(this.getPermissionChecker(), recordSetId, "DELETE");
        this.ddlRecordSetLocalService.deleteRecordSet(recordSetId);
    }

    public DDLRecordSet getRecordSet(long recordSetId) throws PortalException, SystemException {
        DDLRecordSetPermission.check(this.getPermissionChecker(), recordSetId, "VIEW");
        return this.ddlRecordSetLocalService.getRecordSet(recordSetId);
    }

    public List<DDLRecordSet> search(long companyId, long groupId, String keywords, int scope, int start, int end, OrderByComparator orderByComparator) throws SystemException {
        return this.ddlRecordSetFinder.filterFindByKeywords(companyId, groupId, keywords, scope, start, end, orderByComparator);
    }

    public List<DDLRecordSet> search(long companyId, long groupId, String name, String description, int scope, boolean andOperator, int start, int end, OrderByComparator orderByComparator) throws SystemException {
        return this.ddlRecordSetFinder.filterFindByC_G_N_D_S(companyId, groupId, name, description, scope, andOperator, start, end, orderByComparator);
    }

    public int searchCount(long companyId, long groupId, String keywords, int scope) throws SystemException {
        return this.ddlRecordSetFinder.filterCountByKeywords(companyId, groupId, keywords, scope);
    }

    public int searchCount(long companyId, long groupId, String name, String description, int scope, boolean andOperator) throws SystemException {
        return this.ddlRecordSetFinder.filterCountByC_G_N_D_S(companyId, groupId, name, description, scope, andOperator);
    }

    public DDLRecordSet updateMinDisplayRows(long recordSetId, int minDisplayRows, ServiceContext serviceContext) throws PortalException, SystemException {
        DDLRecordSetPermission.check(this.getPermissionChecker(), recordSetId, "UPDATE");
        return this.ddlRecordSetLocalService.updateMinDisplayRows(recordSetId, minDisplayRows, serviceContext);
    }

    public DDLRecordSet updateRecordSet(long recordSetId, long ddmStructureId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, int minDisplayRows, ServiceContext serviceContext) throws PortalException, SystemException {
        DDLRecordSetPermission.check(this.getPermissionChecker(), recordSetId, "UPDATE");
        return this.ddlRecordSetLocalService.updateRecordSet(recordSetId, ddmStructureId, nameMap, descriptionMap, minDisplayRows, serviceContext);
    }

    public DDLRecordSet updateRecordSet(long groupId, long ddmStructureId, String recordSetKey, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, int minDisplayRows, ServiceContext serviceContext) throws PortalException, SystemException {
        DDLRecordSetPermission.check(this.getPermissionChecker(), groupId, recordSetKey, "UPDATE");
        return this.ddlRecordSetLocalService.updateRecordSet(groupId, ddmStructureId, recordSetKey, nameMap, descriptionMap, minDisplayRows, serviceContext);
    }
}

