/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.observation;

import java.util.Set;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.NodeType;
import org.apache.jackrabbit.core.ItemManager;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.nodetype.NodeTypeImpl;
import org.apache.jackrabbit.core.observation.EventState;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.spi.commons.conversion.MalformedPathException;

public class EventFilter {
    static final EventFilter BLOCK_ALL = new BlockAllFilter();
    private final ItemManager itemMgr;
    private final SessionImpl session;
    private final long eventTypes;
    private final Path path;
    private final boolean isDeep;
    private final NodeId[] ids;
    private final NodeTypeImpl[] nodeTypes;
    private final boolean noLocal;

    EventFilter(ItemManager itemMgr, SessionImpl session, long eventTypes, Path path, boolean isDeep, NodeId[] ids, NodeTypeImpl[] nodeTypes, boolean noLocal) {
        this.itemMgr = itemMgr;
        this.session = session;
        this.eventTypes = eventTypes;
        this.path = path;
        this.isDeep = isDeep;
        this.ids = ids;
        this.noLocal = noLocal;
        this.nodeTypes = nodeTypes;
    }

    SessionImpl getSession() {
        return this.session;
    }

    ItemManager getItemManager() {
        return this.itemMgr;
    }

    boolean blocks(EventState eventState) throws RepositoryException {
        boolean match;
        long type = eventState.getType();
        if ((this.eventTypes & type) == 0L) {
            return true;
        }
        if (this.noLocal && this.session.equals(eventState.getSession())) {
            return true;
        }
        NodeId parentId = eventState.getParentId();
        if (this.ids != null) {
            boolean match2 = false;
            for (int i = 0; i < this.ids.length && !match2; match2 |= parentId.equals(this.ids[i]), ++i) {
            }
            if (!match2) {
                return true;
            }
        }
        if (this.nodeTypes != null) {
            Set<NodeType> eventTypes = eventState.getNodeTypes(this.session.getNodeTypeManager());
            match = false;
            for (int i = 0; i < this.nodeTypes.length && !match; ++i) {
                for (NodeTypeImpl nodeTypeImpl : eventTypes) {
                    match |= nodeTypeImpl.getQName().equals(this.nodeTypes[i].getQName()) || nodeTypeImpl.isDerivedFrom(this.nodeTypes[i].getQName());
                }
            }
            if (!match) {
                return true;
            }
        }
        try {
            Path eventPath = eventState.getParentPath();
            match = eventPath.equals(this.path);
            if (!match && this.isDeep) {
                match = eventPath.isDescendantOf(this.path);
            }
            return !match;
        }
        catch (MalformedPathException mpe) {
            throw new RepositoryException("internal error: failed to check path filter", (Throwable)mpe);
        }
    }

    private static final class BlockAllFilter
    extends EventFilter {
        BlockAllFilter() {
            super(null, null, 0L, null, true, null, null, true);
        }

        boolean blocks(EventState eventState) {
            return true;
        }
    }
}

