/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.jdbc.pool;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;
import org.hsqldb.jdbc.JDBCConnection;
import org.hsqldb.jdbc.JDBCConnectionEventListener;
import org.hsqldb.lib.OrderedHashSet;

class JDBCPooledConnection
implements PooledConnection,
JDBCConnectionEventListener {
    protected OrderedHashSet listeners = new OrderedHashSet();
    protected JDBCConnection connection;
    protected JDBCConnection userConnection;
    protected boolean isInUse;

    public synchronized Connection getConnection() throws SQLException {
        if (this.isInUse) {
            throw new SQLException("Connection in use");
        }
        this.isInUse = true;
        this.userConnection = new JDBCConnection(this.connection, this);
        return this.userConnection;
    }

    public void close() throws SQLException {
        if (this.connection != null) {
            this.connection.closeFully();
            this.connection = null;
        }
    }

    public void addConnectionEventListener(ConnectionEventListener listener) {
        this.listeners.add(listener);
    }

    public void removeConnectionEventListener(ConnectionEventListener listener) {
        this.listeners.remove(listener);
    }

    public synchronized void connectionClosed() {
        ConnectionEvent event = new ConnectionEvent(this);
        this.userConnection = null;
        this.release();
        for (int i = 0; i < this.listeners.size(); ++i) {
            ConnectionEventListener connectionEventListener = (ConnectionEventListener)this.listeners.get(i);
            connectionEventListener.connectionClosed(event);
        }
    }

    public synchronized void connectionErrorOccured(SQLException e) {
        ConnectionEvent event = new ConnectionEvent(this, e);
        this.release();
        for (int i = 0; i < this.listeners.size(); ++i) {
            ConnectionEventListener connectionEventListener = (ConnectionEventListener)this.listeners.get(i);
            connectionEventListener.connectionErrorOccurred(event);
        }
    }

    public synchronized boolean isInUse() {
        return this.isInUse;
    }

    public synchronized void release() {
        if (this.userConnection != null) {
            try {
                this.userConnection.close();
            }
            catch (SQLException e) {
                // empty catch block
            }
        }
        try {
            this.connection.reset();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.isInUse = false;
    }

    public JDBCPooledConnection(JDBCConnection connection) {
        this.connection = connection;
    }
}

