/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.verify;

import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.staging.Staging;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.verify.VerifyProcess;
import com.liferay.portlet.dynamicdatamapping.util.DDMXMLUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Iterator;

public class VerifyPortalPreferences
extends VerifyProcess {
    protected String convertStagingPreferencesToJSON(String preferences) throws Exception {
        Document newDocument = SAXReaderUtil.createDocument();
        Element newRootElement = SAXReaderUtil.createElement((String)"portlet-preferences");
        newDocument.add(newRootElement);
        Document document = SAXReaderUtil.read((String)preferences);
        Element rootElement = document.getRootElement();
        Iterator iterator = rootElement.elementIterator();
        HashMap<String, Object> stagingPreferencesMap = new HashMap<String, Object>();
        while (iterator.hasNext()) {
            Element preferenceElement = (Element)iterator.next();
            String preferenceName = preferenceElement.elementText("name");
            if (preferenceName.contains(Staging.class.getName())) {
                String preferenceValue = preferenceElement.elementText("value");
                int index = preferenceName.indexOf("#");
                stagingPreferencesMap.put(preferenceName.substring(index + 1), preferenceValue);
                continue;
            }
            newRootElement.add(preferenceElement.createCopy());
        }
        JSONArray stagingPreferencesJsonArray = JSONFactoryUtil.createJSONArray();
        for (String key : stagingPreferencesMap.keySet()) {
            JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
            jsonObject.put(key, (String)stagingPreferencesMap.get(key));
            stagingPreferencesJsonArray.put(jsonObject);
        }
        if (stagingPreferencesJsonArray.length() > 0) {
            Element preferenceElement = SAXReaderUtil.createElement((String)"preference");
            Element nameElement = SAXReaderUtil.createElement((String)"name");
            String stagingPreferencesName = String.valueOf(Staging.class.getName()) + "#" + "stagingRecentLayoutIdsMap";
            nameElement.setText(stagingPreferencesName);
            Element valueElement = SAXReaderUtil.createElement((String)"value");
            valueElement.setText(stagingPreferencesJsonArray.toString());
            preferenceElement.add(nameElement);
            preferenceElement.add(valueElement);
            newRootElement.add(preferenceElement);
        }
        return DDMXMLUtil.formatXML((Document)newDocument);
    }

    @Override
    protected void doVerify() throws Exception {
        this.updatePortalPreferences();
    }

    protected void updatePortalPreferences() throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getUpgradeOptimizedConnection();
            ps = con.prepareStatement("select portalPreferencesId, preferences from PortalPreferences");
            rs = ps.executeQuery();
            while (rs.next()) {
                long portalPreferencesId = rs.getLong("portalPreferencesId");
                String preferences = rs.getString("preferences");
                this.updateUserStagingPreferences(portalPreferencesId, preferences);
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, (Statement)ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
    }

    protected void updateUserStagingPreferences(long portalPreferencesId, String preferences) throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DataAccess.getUpgradeOptimizedConnection();
            ps = con.prepareStatement("update PortalPreferences set preferences = ? where portalPreferencesId = ?");
            ps.setString(1, this.convertStagingPreferencesToJSON(preferences));
            ps.setLong(2, portalPreferencesId);
            ps.executeUpdate();
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, ps);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps);
    }
}

