/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.util;

import com.liferay.portal.kernel.configuration.Filter;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.model.Layout;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.security.permission.PermissionThreadLocal;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import com.liferay.portal.service.permission.LayoutPermissionUtil;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import java.util.HashMap;
import java.util.Map;

public class LayoutSettings {
    private static Log _log = LogFactoryUtil.getLog(LayoutSettings.class);
    private static final String _URL = "${liferay:mainPath}/portal/layout?p_l_id=${liferay:plid}&p_v_l_s_g_id=${liferay:pvlsgid}";
    private static Map<String, LayoutSettings> _layoutSettingsMap = new HashMap<String, LayoutSettings>();
    private String[] _configurationActionDelete;
    private String[] _configurationActionUpdate;
    private String _editPage;
    private boolean _firstPageable;
    private boolean _parentable;
    private boolean _sitemapable;
    private String _type;
    private String _url;
    private boolean _urlFriendliable;
    private String _viewPage;

    static {
        _layoutSettingsMap.put("control_panel", new LayoutSettings("control_panel"));
        String[] stringArray = PropsValues.LAYOUT_TYPES;
        int n = PropsValues.LAYOUT_TYPES.length;
        int n2 = 0;
        while (n2 < n) {
            String type = stringArray[n2];
            _layoutSettingsMap.put(type, new LayoutSettings(type));
            ++n2;
        }
    }

    public static void addLayoutSetting(String type) {
        _layoutSettingsMap.put(type, new LayoutSettings(type));
    }

    public static LayoutSettings getInstance(Layout layout) {
        return LayoutSettings.getInstance(layout.getType());
    }

    public static LayoutSettings getInstance(String type) {
        return _layoutSettingsMap.get(type);
    }

    public static Map<String, LayoutSettings> getLayoutSettingsMap() {
        return _layoutSettingsMap;
    }

    public String[] getConfigurationActionDelete() {
        return this._configurationActionDelete;
    }

    public String[] getConfigurationActionUpdate() {
        return this._configurationActionUpdate;
    }

    public String getEditPage() {
        return this._editPage;
    }

    public String getType() {
        return this._type;
    }

    public String getURL() {
        return this._url;
    }

    public String getURL(Map<String, String> variables) {
        long plid = GetterUtil.getLong((String)variables.get("liferay:plid"));
        String url = this.getDefaultURL();
        try {
            Layout layout = LayoutLocalServiceUtil.getLayout((long)plid);
            if (this.hasViewPermission(layout)) {
                url = this.getURL();
            }
        }
        catch (Exception e2) {
            _log.error((Throwable)e2);
        }
        return this.replaceVariables(url, variables);
    }

    public String getViewPage() {
        return this._viewPage;
    }

    public boolean isFirstPageable() {
        return this._firstPageable;
    }

    public boolean isParentable() {
        return this._parentable;
    }

    public boolean isSitemapable() {
        return this._sitemapable;
    }

    public boolean isURLFriendliable() {
        return this._urlFriendliable;
    }

    protected boolean hasViewPermission(Layout layout) {
        if (layout.isTypeControlPanel()) {
            return false;
        }
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        if (permissionChecker == null) {
            return false;
        }
        try {
            return LayoutPermissionUtil.contains((PermissionChecker)permissionChecker, (Layout)layout, (String)"VIEW");
        }
        catch (Exception e2) {
            _log.error((Throwable)e2);
            return false;
        }
    }

    protected String replaceVariables(String url, Map<String, String> variables) {
        return StringUtil.replace((String)url, (String)"${", (String)"}", variables);
    }

    protected String getDefaultURL() {
        return _URL;
    }

    private LayoutSettings(String type) {
        this._type = type;
        Filter filter = new Filter(type);
        this._configurationActionDelete = StringUtil.split((String)GetterUtil.getString((String)PropsUtil.get("layout.configuration.action.delete", filter)));
        this._configurationActionUpdate = StringUtil.split((String)GetterUtil.getString((String)PropsUtil.get("layout.configuration.action.update", filter)));
        this._editPage = GetterUtil.getString((String)PropsUtil.get("layout.edit.page", filter));
        this._firstPageable = GetterUtil.getBoolean((String)PropsUtil.get("layout.first.pageable", filter));
        this._parentable = GetterUtil.getBoolean((String)PropsUtil.get("layout.parentable", filter), (boolean)true);
        this._sitemapable = GetterUtil.getBoolean((String)PropsUtil.get("layout.sitemapable", filter), (boolean)true);
        this._url = GetterUtil.getString((String)PropsUtil.get("layout.url", filter));
        this._urlFriendliable = GetterUtil.getBoolean((String)PropsUtil.get("layout.url.friendliable", filter), (boolean)true);
        this._viewPage = GetterUtil.getString((String)PropsUtil.get("layout.view.page", filter));
    }
}

