/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.tools.view.tools;

import java.util.Map;
import javax.servlet.ServletRequest;
import org.apache.velocity.tools.generic.ValueParser;
import org.apache.velocity.tools.view.context.ViewContext;

public class ParameterParser
extends ValueParser {
    private ServletRequest request;

    public ParameterParser() {
    }

    public ParameterParser(ServletRequest request) {
        this.setRequest(request);
    }

    public void init(Object obj) {
        if (obj instanceof ViewContext) {
            this.setRequest((ServletRequest)((ViewContext)obj).getRequest());
        } else if (obj instanceof ServletRequest) {
            this.setRequest((ServletRequest)obj);
        } else {
            throw new IllegalArgumentException("Was expecting " + ViewContext.class + " or " + ServletRequest.class);
        }
    }

    protected void setRequest(ServletRequest request) {
        this.request = request;
    }

    protected ServletRequest getRequest() {
        if (this.request == null) {
            throw new UnsupportedOperationException("Request is null. ParameterParser must be initialized first!");
        }
        return this.request;
    }

    public String getString(String key) {
        return this.getRequest().getParameter(key);
    }

    public String[] getStrings(String key) {
        return this.getRequest().getParameterValues(key);
    }

    protected void setSource(Map source) {
        throw new UnsupportedOperationException();
    }

    protected Map getSource() {
        return this.getRequest().getParameterMap();
    }

    public Map getAll() {
        return this.getSource();
    }
}

