/*
 * Decompiled with CFR 0.152.
 */
package com.ecyrd.jspwiki.plugin;

import com.ecyrd.jspwiki.ReferenceManager;
import com.ecyrd.jspwiki.TextUtil;
import com.ecyrd.jspwiki.WikiContext;
import com.ecyrd.jspwiki.WikiPage;
import com.ecyrd.jspwiki.plugin.AbstractReferralPlugin;
import com.ecyrd.jspwiki.plugin.PluginException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.log4j.Logger;

public class ReferringPagesPlugin
extends AbstractReferralPlugin {
    private static Logger log = Logger.getLogger(ReferringPagesPlugin.class);
    public static final String PARAM_MAX = "max";
    public static final String PARAM_EXTRAS = "extras";
    public static final String PARAM_PAGE = "page";

    public String execute(WikiContext context, Map params) throws PluginException {
        WikiPage page;
        ReferenceManager refmgr = context.getEngine().getReferenceManager();
        String pageName = (String)params.get(PARAM_PAGE);
        ResourceBundle rb = context.getBundle("plugin.PluginResources");
        StringBuffer result = new StringBuffer(256);
        if (pageName == null) {
            pageName = context.getPage().getName();
        }
        if ((page = context.getEngine().getPage(pageName)) != null) {
            Collection links = refmgr.findReferrers(page.getName());
            String wikitext = "";
            super.initialize(context, params);
            int items = TextUtil.parseIntParameter((String)params.get(PARAM_MAX), -1);
            String extras = (String)params.get(PARAM_EXTRAS);
            if (extras == null) {
                extras = rb.getString("referringpagesplugin.more");
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Fetching referring pages for " + page.getName() + " with a max of " + items));
            }
            if (links != null && links.size() > 0) {
                links = this.filterAndSortCollection(links);
                wikitext = this.wikitizeCollection(links, this.m_separator, items);
                result.append(this.makeHTML(context, wikitext));
                if (items < links.size() && items > 0) {
                    Object[] args = new Object[]{"" + (links.size() - items)};
                    extras = MessageFormat.format(extras, args);
                    result.append("<br />");
                    result.append("<a class='morelink' href='" + context.getURL(WikiContext.INFO, page.getName()) + "' ");
                    result.append(">" + extras + "</a><br />");
                }
            }
            if (links == null || links.size() == 0) {
                wikitext = rb.getString("referringpagesplugin.nobody");
                result.append(this.makeHTML(context, wikitext));
            } else if (this.m_show.equals("count")) {
                result = new StringBuffer();
                result.append(links.size());
                if (this.m_lastModified) {
                    result.append(" (" + this.m_dateFormat.format(this.m_dateLastModified) + ")");
                }
            }
            return result.toString();
        }
        return "";
    }
}

