/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools.sourceformatter;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.tools.sourceformatter.BaseSourceProcessor;
import java.io.File;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CSSSourceProcessor
extends BaseSourceProcessor {
    private Pattern _commentPattern = Pattern.compile("/\\* -+(.+)-+ \\*/");

    protected String fixComments(String content) {
        Matcher matcher = this._commentPattern.matcher(content);
        while (matcher.find()) {
            String[] words = StringUtil.split((String)matcher.group(1), (char)' ');
            int i2 = 1;
            while (i2 < words.length) {
                String word;
                String previousWord = words[i2 - 1];
                if (!previousWord.endsWith(".") && !previousWord.equals("/") && (word = words[i2]).length() > 1 && Character.isUpperCase(word.charAt(0)) && StringUtil.isLowerCase((String)word.substring(1))) {
                    content = StringUtil.replaceFirst((String)content, (String)word, (String)StringUtil.toLowerCase((String)word), (int)matcher.start());
                }
                ++i2;
            }
        }
        return content;
    }

    @Override
    protected void format() throws Exception {
        String[] excludes = new String[]{"**\\.sass-cache\\**", "**\\aui_deprecated.css", "**\\js\\aui\\**", "**\\js\\editor\\**", "**\\js\\misc\\**", "**\\VAADIN\\**"};
        String[] includes = new String[]{"**\\*.css"};
        List<String> fileNames = this.getFileNames(excludes, includes);
        for (String fileName : fileNames) {
            this.format(fileName);
        }
    }

    @Override
    protected String format(String fileName) throws Exception {
        File file = new File("./" + fileName);
        fileName = StringUtil.replace((String)fileName, (String)"\\", (String)"/");
        String content = fileUtil.read(file);
        String newContent = this.trimContent(content, false);
        newContent = this.fixComments(newContent);
        if (this.isAutoFix() && newContent != null && !content.equals(newContent)) {
            fileUtil.write(file, newContent);
            sourceFormatterHelper.printError(fileName, file);
        }
        return newContent;
    }
}

