/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.cluster;

import com.liferay.portal.kernel.io.Deserializer;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.concurrent.CountDownLatch;
import org.jgroups.Address;
import org.jgroups.Message;
import org.jgroups.Receiver;
import org.jgroups.View;

public abstract class BaseReceiver
implements Receiver {
    private static Log _log = LogFactoryUtil.getLog(BaseReceiver.class);
    private final CountDownLatch _countDownLatch = new CountDownLatch(1);
    private volatile View _view;

    public void block() {
    }

    public void getState(OutputStream outputStream) throws Exception {
    }

    public View getView() {
        return this._view;
    }

    public void openLatch() {
        this._countDownLatch.countDown();
    }

    public void receive(Message message) {
        try {
            this._countDownLatch.await();
        }
        catch (InterruptedException interruptedException) {
            _log.error((Object)"Latch opened prematurely by interruption. Dependence may not be ready.");
        }
        this.doReceive(message);
    }

    public void setState(InputStream inputStream) throws Exception {
    }

    public void suspect(Address address) {
    }

    public void unblock() {
    }

    public void viewAccepted(View view) {
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Accepted view " + view));
        }
        if (this._view == null) {
            this._view = view;
            return;
        }
        try {
            this._countDownLatch.await();
        }
        catch (InterruptedException interruptedException) {
            _log.error((Object)"Latch opened prematurely by interruption. Dependence may not be ready.");
        }
        View oldView = this._view;
        this._view = view;
        this.doViewAccepted(oldView, view);
    }

    protected abstract void doReceive(Message var1);

    protected void doViewAccepted(View oldView, View newView) {
    }

    protected Object retrievePayload(Message message) {
        byte[] rawBuffer = message.getRawBuffer();
        if (rawBuffer == null) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)"Message content is null");
            }
            return null;
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(rawBuffer, message.getOffset(), message.getLength());
        Deserializer deserializer = new Deserializer(byteBuffer.slice());
        try {
            return deserializer.readObject();
        }
        catch (ClassNotFoundException cnfe) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)"Unable to deserialize message payload", (Throwable)cnfe);
            }
            return null;
        }
    }
}

