/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.model;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.staging.MergeLayoutPrototypesThreadLocal;
import com.liferay.portal.kernel.staging.StagingUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalClassLoaderUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.ReflectionUtil;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.LayoutBranch;
import com.liferay.portal.model.LayoutRevision;
import com.liferay.portal.model.LayoutSet;
import com.liferay.portal.model.LayoutSetBranch;
import com.liferay.portal.model.LayoutType;
import com.liferay.portal.model.PersistedModel;
import com.liferay.portal.model.User;
import com.liferay.portal.service.LayoutBranchLocalServiceUtil;
import com.liferay.portal.service.LayoutRevisionLocalServiceUtil;
import com.liferay.portal.service.LayoutSetBranchLocalServiceUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextThreadLocal;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.util.LayoutTypePortletFactoryUtil;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class LayoutStagingHandler
implements InvocationHandler,
Serializable {
    private static Log _log = LogFactoryUtil.getLog(LayoutStagingHandler.class);
    private static Set<String> _layoutRevisionMethodNames = new HashSet<String>();
    private Layout _layout;
    private LayoutRevision _layoutRevision;

    static {
        _layoutRevisionMethodNames.add("getColorScheme");
        _layoutRevisionMethodNames.add("getColorSchemeId");
        _layoutRevisionMethodNames.add("getCss");
        _layoutRevisionMethodNames.add("getCssText");
        _layoutRevisionMethodNames.add("getDescription");
        _layoutRevisionMethodNames.add("getGroupId");
        _layoutRevisionMethodNames.add("getHTMLTitle");
        _layoutRevisionMethodNames.add("getIconImage");
        _layoutRevisionMethodNames.add("getIconImageId");
        _layoutRevisionMethodNames.add("getKeywords");
        _layoutRevisionMethodNames.add("getLayoutSet");
        _layoutRevisionMethodNames.add("getName");
        _layoutRevisionMethodNames.add("getRobots");
        _layoutRevisionMethodNames.add("getTheme");
        _layoutRevisionMethodNames.add("getThemeId");
        _layoutRevisionMethodNames.add("getThemeSetting");
        _layoutRevisionMethodNames.add("getTitle");
        _layoutRevisionMethodNames.add("getTypeSettings");
        _layoutRevisionMethodNames.add("getTypeSettingsProperties");
        _layoutRevisionMethodNames.add("getTypeSettingsProperty");
        _layoutRevisionMethodNames.add("getWapColorScheme");
        _layoutRevisionMethodNames.add("getWapColorSchemeId");
        _layoutRevisionMethodNames.add("getWapTheme");
        _layoutRevisionMethodNames.add("getWapThemeId");
        _layoutRevisionMethodNames.add("isContentDisplayPage");
        _layoutRevisionMethodNames.add("isEscapedModel");
        _layoutRevisionMethodNames.add("isIconImage");
        _layoutRevisionMethodNames.add("isInheritLookAndFeel");
        _layoutRevisionMethodNames.add("isInheritWapLookAndFeel");
        _layoutRevisionMethodNames.add("setColorSchemeId");
        _layoutRevisionMethodNames.add("setCss");
        _layoutRevisionMethodNames.add("setDescription");
        _layoutRevisionMethodNames.add("setDescriptionMap");
        _layoutRevisionMethodNames.add("setEscapedModel");
        _layoutRevisionMethodNames.add("setGroupId");
        _layoutRevisionMethodNames.add("setIconImage");
        _layoutRevisionMethodNames.add("setIconImageId");
        _layoutRevisionMethodNames.add("setKeywords");
        _layoutRevisionMethodNames.add("setKeywordsMap");
        _layoutRevisionMethodNames.add("setName");
        _layoutRevisionMethodNames.add("setNameMap");
        _layoutRevisionMethodNames.add("setRobots");
        _layoutRevisionMethodNames.add("setRobotsMap");
        _layoutRevisionMethodNames.add("setThemeId");
        _layoutRevisionMethodNames.add("setTitle");
        _layoutRevisionMethodNames.add("setTitleMap");
        _layoutRevisionMethodNames.add("setTypeSettings");
        _layoutRevisionMethodNames.add("setTypeSettingsProperties");
        _layoutRevisionMethodNames.add("setWapColorSchemeId");
        _layoutRevisionMethodNames.add("setWapThemeId");
    }

    public LayoutStagingHandler(Layout layout) {
        this(layout, null);
    }

    public Layout getLayout() {
        return this._layout;
    }

    public LayoutRevision getLayoutRevision() {
        return this._layoutRevision;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] arguments) throws Throwable {
        try {
            if (this._layoutRevision == null) {
                return method.invoke((Object)this._layout, arguments);
            }
            String methodName = method.getName();
            if (methodName.equals("getLayoutType")) {
                return this._getLayoutType();
            }
            if (methodName.equals("getRegularURL")) {
                Class<?> layoutRevisionClass = this._layoutRevision.getClass();
                method = layoutRevisionClass.getMethod(methodName, HttpServletRequest.class);
                return method.invoke((Object)this._layoutRevision, arguments);
            }
            if (methodName.equals("toEscapedModel")) {
                if (this._layout.isEscapedModel()) {
                    return this;
                }
                return this._toEscapedModel();
            }
            if (methodName.equals("clone")) {
                return this._clone();
            }
            PersistedModel bean = this._layout;
            if (_layoutRevisionMethodNames.contains(methodName)) {
                try {
                    Class<?> layoutRevisionClass = this._layoutRevision.getClass();
                    method = layoutRevisionClass.getMethod(methodName, ReflectionUtil.getParameterTypes(arguments));
                    bean = this._layoutRevision;
                }
                catch (NoSuchMethodException nsme) {
                    _log.error(nsme, nsme);
                }
            }
            return method.invoke((Object)bean, arguments);
        }
        catch (InvocationTargetException ite) {
            throw ite.getTargetException();
        }
    }

    public void setLayoutRevision(LayoutRevision layoutRevision) {
        this._layoutRevision = layoutRevision;
    }

    private LayoutStagingHandler(Layout layout, LayoutRevision layoutRevision) {
        this._layout = layout;
        try {
            this._layoutRevision = this._getLayoutRevision(layout, layoutRevision);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new IllegalStateException(e);
        }
    }

    private Object _clone() {
        return ProxyUtil.newProxyInstance(PortalClassLoaderUtil.getClassLoader(), new Class[]{Layout.class}, new LayoutStagingHandler(this._layout, this._layoutRevision));
    }

    private LayoutRevision _getLayoutRevision(Layout layout, LayoutRevision layoutRevision) throws PortalException, SystemException {
        if (layoutRevision != null) {
            return layoutRevision;
        }
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        if (serviceContext == null || !serviceContext.isSignedIn()) {
            LayoutRevision lastLayoutRevision = null;
            lastLayoutRevision = LayoutRevisionLocalServiceUtil.fetchLastLayoutRevision(layout.getPlid(), true);
            if (lastLayoutRevision == null) {
                lastLayoutRevision = LayoutRevisionLocalServiceUtil.fetchLastLayoutRevision(layout.getPlid(), false);
            }
            return lastLayoutRevision;
        }
        User user = UserLocalServiceUtil.getUser(serviceContext.getUserId());
        long layoutSetBranchId = ParamUtil.getLong(serviceContext, "layoutSetBranchId");
        LayoutSet layoutSet = layout.getLayoutSet();
        LayoutSetBranch layoutSetBranch = LayoutSetBranchLocalServiceUtil.getUserLayoutSetBranch(serviceContext.getUserId(), layout.getGroupId(), layout.isPrivateLayout(), layoutSet.getLayoutSetId(), layoutSetBranchId);
        layoutSetBranchId = layoutSetBranch.getLayoutSetBranchId();
        long layoutRevisionId = ParamUtil.getLong(serviceContext, "layoutRevisionId");
        if (layoutRevisionId > 0L) {
            layoutRevision = LayoutRevisionLocalServiceUtil.fetchLayoutRevision(layoutRevisionId);
        }
        if (layoutRevisionId <= 0L || !this._isBelongsToLayout(layoutRevision, layout)) {
            layoutRevisionId = StagingUtil.getRecentLayoutRevisionId(user, layoutSetBranchId, layout.getPlid());
            layoutRevision = LayoutRevisionLocalServiceUtil.fetchLayoutRevision(layoutRevisionId);
        }
        if (layoutRevision != null && !layoutRevision.isInactive()) {
            return layoutRevision;
        }
        layoutRevision = LayoutRevisionLocalServiceUtil.fetchLatestLayoutRevision(layoutSetBranchId, layout.getPlid());
        if (layoutRevision != null) {
            StagingUtil.setRecentLayoutRevisionId(user, layoutSetBranchId, layout.getPlid(), layoutRevision.getLayoutRevisionId());
            return layoutRevision;
        }
        LayoutBranch layoutBranch = LayoutBranchLocalServiceUtil.getMasterLayoutBranch(layoutSetBranchId, layout.getPlid(), serviceContext);
        if (!MergeLayoutPrototypesThreadLocal.isInProgress()) {
            serviceContext.setWorkflowAction(2);
        }
        layoutRevision = LayoutRevisionLocalServiceUtil.addLayoutRevision(serviceContext.getUserId(), layoutSetBranchId, layoutBranch.getLayoutBranchId(), 0L, false, layout.getPlid(), 0L, layout.isPrivateLayout(), layout.getName(), layout.getTitle(), layout.getDescription(), layout.getKeywords(), layout.getRobots(), layout.getTypeSettings(), layout.getIconImage(), layout.getIconImageId(), layout.getThemeId(), layout.getColorSchemeId(), layout.getWapThemeId(), layout.getWapColorSchemeId(), layout.getCss(), serviceContext);
        boolean explicitCreation = ParamUtil.getBoolean(serviceContext, "explicitCreation");
        if (!explicitCreation) {
            LayoutRevisionLocalServiceUtil.updateStatus(serviceContext.getUserId(), layoutRevision.getLayoutRevisionId(), 6, serviceContext);
        }
        return layoutRevision;
    }

    private LayoutType _getLayoutType() {
        return LayoutTypePortletFactoryUtil.create((Layout)ProxyUtil.newProxyInstance(PortalClassLoaderUtil.getClassLoader(), new Class[]{Layout.class}, new LayoutStagingHandler(this._layout, this._layoutRevision)));
    }

    private boolean _isBelongsToLayout(LayoutRevision layoutRevision, Layout layout) {
        if (layoutRevision == null) {
            return false;
        }
        return layoutRevision.getPlid() == layout.getPlid();
    }

    private Object _toEscapedModel() {
        return ProxyUtil.newProxyInstance(PortalClassLoaderUtil.getClassLoader(), new Class[]{Layout.class}, new LayoutStagingHandler(this._layout.toEscapedModel(), this._layoutRevision.toEscapedModel()));
    }
}

