/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.photoshop;

import com.drew.lang.BufferBoundsException;
import com.drew.lang.BufferReader;
import com.drew.lang.annotations.NotNull;
import com.drew.metadata.Metadata;
import com.drew.metadata.MetadataReader;
import com.drew.metadata.photoshop.PsdHeaderDirectory;

public class PsdReader
implements MetadataReader {
    public void extract(@NotNull BufferReader reader, @NotNull Metadata metadata) {
        PsdHeaderDirectory directory = metadata.getOrCreateDirectory(PsdHeaderDirectory.class);
        try {
            int signature = reader.getInt32(0);
            if (signature != 943870035) {
                directory.addError("Invalid PSD file signature");
                return;
            }
            int version = reader.getUInt16(4);
            if (version != 1 && version != 2) {
                directory.addError("Invalid PSD file version (must be 1 or 2)");
                return;
            }
            int channelCount = reader.getUInt16(12);
            directory.setInt(1, channelCount);
            int imageHeight = reader.getInt32(14);
            directory.setInt(2, imageHeight);
            int imageWidth = reader.getInt32(18);
            directory.setInt(3, imageWidth);
            int bitsPerChannel = reader.getUInt16(22);
            directory.setInt(4, bitsPerChannel);
            int colorMode = reader.getUInt16(24);
            directory.setInt(5, colorMode);
        }
        catch (BufferBoundsException e) {
            directory.addError("Unable to read PSD header");
        }
    }
}

