/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.journal.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.journal.model.JournalArticle;
import com.liferay.portlet.journal.model.JournalStructure;
import com.liferay.portlet.journal.service.base.JournalStructureServiceBaseImpl;
import com.liferay.portlet.journal.service.permission.JournalPermission;
import com.liferay.portlet.journal.service.permission.JournalStructurePermission;
import com.liferay.portlet.journal.util.JournalUtil;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class JournalStructureServiceImpl
extends JournalStructureServiceBaseImpl {
    public JournalStructure addStructure(long groupId, String structureId, boolean autoStructureId, String parentStructureId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, String xsd, ServiceContext serviceContext) throws PortalException, SystemException {
        JournalPermission.check(this.getPermissionChecker(), groupId, "ADD_STRUCTURE");
        return this.journalStructureLocalService.addStructure(this.getUserId(), groupId, structureId, autoStructureId, parentStructureId, nameMap, descriptionMap, xsd, serviceContext);
    }

    public JournalStructure copyStructure(long groupId, String oldStructureId, String newStructureId, boolean autoStructureId) throws PortalException, SystemException {
        JournalPermission.check(this.getPermissionChecker(), groupId, "ADD_STRUCTURE");
        return this.journalStructureLocalService.copyStructure(this.getUserId(), groupId, oldStructureId, newStructureId, autoStructureId);
    }

    public void deleteStructure(long groupId, String structureId) throws PortalException, SystemException {
        JournalStructurePermission.check(this.getPermissionChecker(), groupId, structureId, "DELETE");
        this.journalStructureLocalService.deleteStructure(groupId, structureId);
    }

    public JournalStructure getStructure(long groupId, String structureId) throws PortalException, SystemException {
        JournalStructurePermission.check(this.getPermissionChecker(), groupId, structureId, "VIEW");
        return this.journalStructureLocalService.getStructure(groupId, structureId);
    }

    public JournalStructure getStructure(long groupId, String structureId, boolean includeGlobalStructures) throws PortalException, SystemException {
        JournalStructurePermission.check(this.getPermissionChecker(), groupId, structureId, "VIEW");
        return this.journalStructureLocalService.getStructure(groupId, structureId, includeGlobalStructures);
    }

    public List<JournalStructure> getStructures(long groupId) throws SystemException {
        List ddmStructures = this.ddmStructurePersistence.filterFindByG_C(groupId, PortalUtil.getClassNameId(JournalArticle.class));
        return JournalUtil.toJournalStructures(ddmStructures);
    }

    public List<JournalStructure> getStructures(long[] groupIds) throws SystemException {
        List ddmStructures = this.ddmStructurePersistence.filterFindByG_C(groupIds, PortalUtil.getClassNameId(JournalArticle.class));
        return JournalUtil.toJournalStructures(ddmStructures);
    }

    public List<JournalStructure> search(long companyId, long[] groupIds, String keywords, int start, int end, OrderByComparator obc) throws SystemException {
        long[] classNameIds = new long[]{PortalUtil.getClassNameId(JournalArticle.class)};
        List ddmStructures = this.ddmStructureFinder.filterFindByKeywords(companyId, groupIds, classNameIds, keywords, start, end, obc);
        return JournalUtil.toJournalStructures(ddmStructures);
    }

    public List<JournalStructure> search(long companyId, long[] groupIds, String structureId, String name, String description, boolean andOperator, int start, int end, OrderByComparator obc) throws SystemException {
        long[] classNameIds = new long[]{PortalUtil.getClassNameId(JournalArticle.class)};
        List ddmStructures = this.ddmStructureFinder.filterFindByC_G_C_N_D_S_T(companyId, groupIds, classNameIds, name, description, null, 0, andOperator, start, end, obc);
        return JournalUtil.toJournalStructures(ddmStructures);
    }

    public int searchCount(long companyId, long[] groupIds, String keywords) throws SystemException {
        long[] classNameIds = new long[]{PortalUtil.getClassNameId(JournalArticle.class)};
        return this.ddmStructureFinder.filterCountByKeywords(companyId, groupIds, classNameIds, keywords);
    }

    public int searchCount(long companyId, long[] groupIds, String structureId, String name, String description, boolean andOperator) throws SystemException {
        long[] classNameIds = new long[]{PortalUtil.getClassNameId(JournalArticle.class)};
        return this.ddmStructureFinder.filterCountByC_G_C_N_D_S_T(companyId, groupIds, classNameIds, name, description, null, 0, andOperator);
    }

    public JournalStructure updateStructure(long groupId, String structureId, String parentStructureId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, String xsd, ServiceContext serviceContext) throws PortalException, SystemException {
        JournalStructurePermission.check(this.getPermissionChecker(), groupId, structureId, "UPDATE");
        return this.journalStructureLocalService.updateStructure(groupId, structureId, parentStructureId, nameMap, descriptionMap, xsd, serviceContext);
    }
}

