/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.repository.cmis;

import com.liferay.portal.InvalidRepositoryException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.repository.RepositoryException;
import com.liferay.portal.kernel.repository.cmis.Session;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.repository.cmis.SessionImpl;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.service.persistence.RepositoryUtil;
import java.util.HashSet;
import java.util.Map;
import org.apache.chemistry.opencmis.client.api.OperationContext;
import org.apache.chemistry.opencmis.client.api.Repository;
import org.apache.chemistry.opencmis.client.api.SessionFactory;
import org.apache.chemistry.opencmis.client.runtime.OperationContextImpl;
import org.apache.chemistry.opencmis.client.runtime.SessionFactoryImpl;
import org.apache.chemistry.opencmis.commons.enums.IncludeRelationships;
import org.apache.chemistry.opencmis.commons.exceptions.CmisPermissionDeniedException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisUnauthorizedException;

public class CMISRepositoryUtil {
    private static OperationContext _operationContext;
    private static SessionFactory _sessionFactory;

    static {
        _sessionFactory = SessionFactoryImpl.newInstance();
        HashSet<String> defaultFilterSet = new HashSet<String>();
        defaultFilterSet.add("cmis:baseTypeId");
        defaultFilterSet.add("cmis:createdBy");
        defaultFilterSet.add("cmis:creationDate");
        defaultFilterSet.add("cmis:lastModifiedBy");
        defaultFilterSet.add("cmis:lastModificationDate");
        defaultFilterSet.add("cmis:name");
        defaultFilterSet.add("cmis:objectId");
        defaultFilterSet.add("cmis:objectTypeId");
        defaultFilterSet.add("cmis:contentStreamLength");
        defaultFilterSet.add("cmis:contentStreamMimeType");
        defaultFilterSet.add("cmis:isVersionSeriesCheckedOut");
        defaultFilterSet.add("cmis:versionLabel");
        defaultFilterSet.add("cmis:versionSeriesCheckedOutBy");
        defaultFilterSet.add("cmis:versionSeriesCheckedOutId");
        defaultFilterSet.add("cmis:versionSeriesId");
        defaultFilterSet.add("cmis:parentId");
        defaultFilterSet.add("cmis:path");
        _operationContext = new OperationContextImpl(defaultFilterSet, false, true, false, IncludeRelationships.NONE, null, false, "cmis:name ASC", true, 1000);
    }

    public static void checkRepository(long repositoryId, Map<String, String> parameters, UnicodeProperties typeSettingsProperties, String typeSettingsKey) throws PortalException, RepositoryException {
        if (!typeSettingsProperties.containsKey((Object)typeSettingsKey)) {
            Repository cmisRepository = (Repository)_sessionFactory.getRepositories(parameters).get(0);
            typeSettingsProperties.setProperty(typeSettingsKey, cmisRepository.getId());
            try {
                com.liferay.portal.model.Repository repository = RepositoryUtil.findByPrimaryKey((long)repositoryId);
                repository.setTypeSettingsProperties(typeSettingsProperties);
                RepositoryUtil.update((com.liferay.portal.model.Repository)repository);
            }
            catch (Exception e2) {
                throw new RepositoryException((Throwable)e2);
            }
        }
        parameters.put("org.apache.chemistry.opencmis.session.repository.id", CMISRepositoryUtil.getTypeSettingsValue(typeSettingsProperties, typeSettingsKey));
    }

    public static Session createSession(Map<String, String> parameters) throws PrincipalException, RepositoryException {
        try {
            org.apache.chemistry.opencmis.client.api.Session session = _sessionFactory.createSession(parameters);
            session.setDefaultContext(_operationContext);
            return new SessionImpl(session);
        }
        catch (CmisPermissionDeniedException cpde) {
            throw new PrincipalException((Throwable)cpde);
        }
        catch (CmisUnauthorizedException cmisUnauthorizedException) {
            throw new PrincipalException();
        }
        catch (Exception e2) {
            throw new RepositoryException((Throwable)e2);
        }
    }

    public static OperationContext getOperationContext() {
        return _operationContext;
    }

    public static SessionFactory getSessionFactory() {
        return _sessionFactory;
    }

    public static String getTypeSettingsValue(UnicodeProperties typeSettingsProperties, String typeSettingsKey) throws InvalidRepositoryException {
        String value = typeSettingsProperties.getProperty(typeSettingsKey);
        if (Validator.isNull((String)value)) {
            throw new InvalidRepositoryException("Properties value cannot be null for key " + typeSettingsKey);
        }
        return value;
    }
}

