/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare.rangedifferencer;

import java.util.ArrayList;
import org.eclipse.compare.internal.CompareMessages;
import org.eclipse.compare.internal.LCS;
import org.eclipse.compare.internal.LCSSettings;
import org.eclipse.compare.rangedifferencer.IRangeComparator;
import org.eclipse.compare.rangedifferencer.RangeDifference;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;

class RangeComparatorLCS
extends LCS {
    private final IRangeComparator comparator1;
    private final IRangeComparator comparator2;
    private int[][] lcs;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RangeDifference[] findDifferences(IProgressMonitor iProgressMonitor, LCSSettings lCSSettings, IRangeComparator iRangeComparator, IRangeComparator iRangeComparator2) {
        RangeComparatorLCS rangeComparatorLCS = new RangeComparatorLCS(iRangeComparator, iRangeComparator2);
        SubMonitor subMonitor = SubMonitor.convert(iProgressMonitor, CompareMessages.RangeComparatorLCS_0, 100);
        try {
            rangeComparatorLCS.longestCommonSubsequence(subMonitor.newChild(95), lCSSettings);
            RangeDifference[] rangeDifferenceArray = rangeComparatorLCS.getDifferences(subMonitor.newChild(5));
            return rangeDifferenceArray;
        }
        finally {
            if (iProgressMonitor != null) {
                iProgressMonitor.done();
            }
        }
    }

    public RangeComparatorLCS(IRangeComparator iRangeComparator, IRangeComparator iRangeComparator2) {
        this.comparator1 = iRangeComparator;
        this.comparator2 = iRangeComparator2;
    }

    protected int getLength1() {
        return this.comparator1.getRangeCount();
    }

    protected int getLength2() {
        return this.comparator2.getRangeCount();
    }

    protected void initializeLcs(int n) {
        this.lcs = new int[2][n];
    }

    protected boolean isRangeEqual(int n, int n2) {
        return this.comparator1.rangesEqual(n, this.comparator2, n2);
    }

    protected void setLcs(int n, int n2) {
        this.lcs[0][n] = n + 1;
        this.lcs[1][n] = n2 + 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RangeDifference[] getDifferences(SubMonitor subMonitor) {
        try {
            ArrayList<RangeDifference> arrayList = new ArrayList<RangeDifference>();
            int n = this.getLength();
            if (n == 0) {
                arrayList.add(new RangeDifference(2, 0, this.comparator2.getRangeCount(), 0, this.comparator1.getRangeCount()));
            } else {
                int n2;
                int n3;
                subMonitor.beginTask(null, n);
                int n4 = 0;
                int n5 = -1;
                int n6 = -1;
                for (int i = 0; i < this.lcs[0].length && n4 < this.lcs[1].length; ++i, ++n4) {
                    int n7;
                    int n8;
                    while ((n8 = this.lcs[0][i]) == 0 && ++i < this.lcs[0].length) {
                    }
                    if (i >= this.lcs[0].length) break;
                    while ((n7 = this.lcs[1][n4]) == 0 && ++n4 < this.lcs[1].length) {
                    }
                    if (n4 >= this.lcs[1].length) break;
                    n3 = n8 - 1;
                    n2 = n7 - 1;
                    if (n5 == -1 && (n3 != 0 || n2 != 0)) {
                        arrayList.add(new RangeDifference(2, 0, n2, 0, n3));
                    } else if (n3 != n5 + 1 || n2 != n6 + 1) {
                        int n9 = n5 + 1;
                        int n10 = n3 - n9;
                        int n11 = n6 + 1;
                        int n12 = n2 - n11;
                        arrayList.add(new RangeDifference(2, n11, n12, n9, n10));
                    }
                    n5 = n3;
                    n6 = n2;
                    this.worked(subMonitor, 1);
                }
                if (n5 != -1 && (n5 + 1 < this.comparator1.getRangeCount() || n6 + 1 < this.comparator2.getRangeCount())) {
                    n3 = n5 < this.comparator1.getRangeCount() ? n5 + 1 : n5;
                    n2 = n6 < this.comparator2.getRangeCount() ? n6 + 1 : n6;
                    arrayList.add(new RangeDifference(2, n2, this.comparator2.getRangeCount() - (n6 + 1), n3, this.comparator1.getRangeCount() - (n5 + 1)));
                }
            }
            RangeDifference[] rangeDifferenceArray = arrayList.toArray(new RangeDifference[arrayList.size()]);
            return rangeDifferenceArray;
        }
        finally {
            subMonitor.done();
        }
    }

    private void worked(SubMonitor subMonitor, int n) {
        if (subMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        subMonitor.worked(n);
    }
}

