/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.profile;

import java.util.ArrayList;
import org.jruby.runtime.profile.Invocation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InvocationSet {
    ArrayList<Invocation> invocations;

    public InvocationSet() {
    }

    public InvocationSet(ArrayList<Invocation> invs) {
        this.invocations = invs;
    }

    public long totalTime() {
        long t = 0L;
        for (Invocation inv : this.invocations) {
            t += inv.getDuration();
        }
        return t;
    }

    public long selfTime() {
        return this.totalTime() - this.childTime();
    }

    public long childTime() {
        long t = 0L;
        for (Invocation inv : this.invocations) {
            t += inv.childTime();
        }
        return t;
    }

    public int totalCalls() {
        int t = 0;
        for (Invocation inv : this.invocations) {
            t += inv.getCount();
        }
        return t;
    }

    public long timeSpentInChild(int serial) {
        long t = 0L;
        for (Invocation inv : this.invocations) {
            Invocation childInv = inv.getChildren().get(serial);
            if (childInv == null) continue;
            t += childInv.getDuration();
        }
        return t;
    }

    public int callsOfChild(int serial) {
        int c = 0;
        for (Invocation inv : this.invocations) {
            Invocation childInv = inv.getChildren().get(serial);
            if (childInv == null) continue;
            c += childInv.getCount();
        }
        return c;
    }
}

