/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.query.test;

import com.hp.hpl.jena.rdf.query.Query;
import com.hp.hpl.jena.rdf.query.QueryEngine;
import com.hp.hpl.jena.rdf.query.QueryResults;
import com.hp.hpl.jena.rdf.query.QueryResultsFormatter;
import com.hp.hpl.jena.rdf.query.test.TestQuery;
import com.hp.hpl.mesa.rdf.jena.model.Model;
import com.hp.hpl.mesa.rdf.jena.model.Resource;
import java.util.ArrayList;
import java.util.Iterator;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestQueryAnon
extends TestCase {
    Model model = null;
    public boolean dumpModel = false;
    public boolean verbose = false;

    public TestQueryAnon(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite();
        testSuite.addTest((Test)new TestQueryAnon("Query anon. test "));
        return testSuite;
    }

    public static void addTests(TestSuite testSuite) {
        testSuite.addTest((Test)new TestQueryAnon("RDQL queries (anon) "));
    }

    protected void runTest() throws Throwable {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("SELECT ?x, ?a, ?b, ?y, ?z WHERE (?x, ?a, ?b), (?b, ?y, ?z)");
        arrayList.add("SELECT ?z WHERE (?x, ?y, ?z) AND ?z == 1");
        arrayList.add("SELECT ?z WHERE (<http://never/r-1>, <http://never/p-0>, ?z)");
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (this.verbose) {
                System.out.println();
                System.out.println("Query:");
                System.out.println(string);
            }
            Query query = new Query(string);
            query.setSource(this.model);
            QueryEngine queryEngine = new QueryEngine(query);
            QueryResults queryResults = queryEngine.exec();
            QueryResultsFormatter queryResultsFormatter = new QueryResultsFormatter(queryResults);
            queryResultsFormatter.consume();
        }
    }

    public void setUp() throws Exception {
        this.model = TestQuery.makeModel();
        Resource resource = this.model.createResource();
        Resource resource2 = this.model.createResource();
        this.model.add(resource, this.model.createProperty("http://never/p-anon-1"), "p-anon-1");
        this.model.add(resource2, this.model.createProperty("http://never/p-anon-2"), "p-anon-2");
        this.model.add(resource, this.model.createProperty("http://never/p-anon-1-2"), resource2);
    }

    public void tearDown() {
        this.model = null;
    }
}

