/*
 * Decompiled with CFR 0.152.
 */
package org.jamwiki.parser.jflex;

import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.jamwiki.DataAccessException;
import org.jamwiki.parser.ParserException;
import org.jamwiki.parser.ParserInput;
import org.jamwiki.parser.ParserOutput;
import org.jamwiki.parser.jflex.JAMWikiProcessor;
import org.jamwiki.parser.jflex.JFlexLexer;
import org.jamwiki.parser.jflex.JFlexParserTag;
import org.jamwiki.parser.jflex.JFlexParserUtil;
import org.jamwiki.utils.LinkUtil;
import org.jamwiki.utils.Utilities;
import org.jamwiki.utils.WikiLogger;

public abstract class AbstractHeadingTag
implements JFlexParserTag {
    private static final WikiLogger logger = WikiLogger.getLogger(AbstractHeadingTag.class.getName());

    private String buildSectionEditLink(ParserInput parserInput, int section) {
        boolean disallowInclusion;
        if (!parserInput.getAllowSectionEdit()) {
            return "";
        }
        if (parserInput.getLocale() == null) {
            logger.info("Unable to build section edit links for " + parserInput.getTopicName() + " - locale is empty");
            return "";
        }
        Integer inclusion = (Integer)parserInput.getTempParams().get("template-inclusion");
        boolean bl = disallowInclusion = inclusion != null && inclusion > 0;
        if (disallowInclusion) {
            return "";
        }
        String url = "";
        try {
            url = LinkUtil.buildEditLinkUrl(parserInput.getContext(), parserInput.getVirtualWiki(), parserInput.getTopicName(), null, section);
        }
        catch (DataAccessException e) {
            logger.error("Failure while building link for topic " + parserInput.getVirtualWiki() + " / " + parserInput.getTopicName(), e);
        }
        StringBuilder output = new StringBuilder("<span class=\"editsection\">[<a href=\"").append(url).append("\">");
        output.append(Utilities.formatMessage("common.sectionedit", parserInput.getLocale()));
        output.append("</a>]</span>");
        return output.toString();
    }

    private String buildTagName(JFlexLexer lexer, String tocText) {
        String tagName = StringEscapeUtils.unescapeHtml((String)tocText);
        return lexer.getParserInput().getTableOfContents().buildUniqueName(tagName);
    }

    private String buildTocText(JFlexLexer lexer, String tagText) throws ParserException {
        ParserInput tmpParserInput = new ParserInput(lexer.getParserInput());
        ParserOutput parserOutput = new ParserOutput();
        String tocText = this.processTocText(tmpParserInput, parserOutput, tagText, 7);
        return Utilities.stripMarkup(tocText);
    }

    private String generateOutput(JFlexLexer lexer, String tagName, String tocText, String tagText, int level, String raw, Object ... args) throws ParserException {
        StringBuilder output = new StringBuilder(this.updateToc(lexer.getParserInput(), tagName, tocText, level));
        int nextSection = lexer.getParserInput().getTableOfContents().size();
        output.append("<a name=\"").append(tagName).append("\"></a>");
        output.append(this.generateTagOpen(raw, args));
        output.append(this.buildSectionEditLink(lexer.getParserInput(), nextSection));
        String parsedTocText = this.processTocText(lexer.getParserInput(), lexer.getParserOutput(), tagText, lexer.getMode());
        output.append("<span>").append(parsedTocText).append("</span>");
        output.append("</h").append(level).append('>');
        return output.toString();
    }

    protected abstract int generateTagLevel(String var1, Object ... var2) throws ParserException;

    protected abstract String generateTagOpen(String var1, Object ... var2) throws ParserException;

    protected abstract String generateTagText(String var1, Object ... var2) throws ParserException;

    public String parse(JFlexLexer lexer, String raw, Object ... args) throws ParserException {
        if (logger.isTraceEnabled()) {
            logger.trace("heading: " + raw + " (" + lexer.yystate() + ")");
        }
        int level = this.generateTagLevel(raw, args);
        String tagText = this.generateTagText(raw, args);
        if (lexer.peekTag().getTagType().equals("p")) {
            lexer.popTag("p");
        }
        if (lexer instanceof JAMWikiProcessor && lexer.yystate() == 10) {
            lexer.endState();
        }
        String tocText = this.buildTocText(lexer, tagText);
        String tagName = this.buildTagName(lexer, tocText);
        if (lexer.getMode() <= 2) {
            String sectionName = StringEscapeUtils.unescapeHtml((String)tocText);
            lexer.getParserOutput().setSectionName(sectionName);
            return raw;
        }
        return this.generateOutput(lexer, tagName, tocText, tagText, level, raw, args);
    }

    private String processTocText(ParserInput parserInput, ParserOutput parserOutput, String tagText, int mode) throws ParserException {
        String extraEqualSigns = "";
        int pos = StringUtils.indexOfAnyBut((String)tagText, (String)"= \t");
        if (pos != -1) {
            extraEqualSigns = tagText.substring(0, pos);
            tagText = pos < tagText.length() ? tagText.substring(pos) : "";
        }
        return extraEqualSigns + JFlexParserUtil.parseFragment(parserInput, parserOutput, tagText, mode);
    }

    private String updateToc(ParserInput parserInput, String name, String text, int level) {
        String output = "";
        if (parserInput.getTableOfContents().getStatus() == 0) {
            output = output + "__TOC__";
        }
        parserInput.getTableOfContents().addEntry(name, text, level);
        return output;
    }
}

