/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.mesa.rdf.jena.rdb;

import com.hp.hpl.mesa.rdf.jena.rdb.DBConnection;
import com.hp.hpl.mesa.rdf.jena.rdb.DriverGenericGeneric;
import com.hp.hpl.mesa.rdf.jena.rdb.IRDBDriver;
import com.hp.hpl.mesa.rdf.jena.rdb.RDFRDBException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class TestDBConnection
extends TestCase {
    protected String m_dbname;
    protected String m_user;
    protected String m_password;
    protected String m_layout;
    protected String m_database;

    public TestDBConnection(String string, String string2, String string3) {
        super(string);
        this.m_layout = string2;
        this.m_database = string3;
    }

    public void setUp() throws ClassNotFoundException {
        this.m_dbname = System.getProperty("jena.rdb.test.dbfull");
        this.m_user = System.getProperty("jena.rdb.test.user", "DER");
        this.m_password = System.getProperty("jena.rdb.test.password", "key");
    }

    public void tearDown() {
    }

    public void testBasicOperations() throws SQLException, RDFRDBException, ClassNotFoundException {
        DBConnection dBConnection = new DBConnection(this.m_dbname, this.m_user, this.m_password);
        IRDBDriver iRDBDriver = dBConnection.getDriver(this.m_layout, this.m_database);
        System.out.println("Driver = " + iRDBDriver);
        Class.forName(((DriverGenericGeneric)iRDBDriver).DRIVER_NAME);
        Connection connection = dBConnection.getConnection();
        Assert.assertNotNull((Object)connection);
        dBConnection.close();
        Assert.assertNotNull((Object)iRDBDriver);
        String string = "com.hp.hpl.mesa.rdf.jena.rdb.Driver" + this.m_database + this.m_layout;
        if (iRDBDriver.isDBFormatOK()) {
            iRDBDriver.cleanDB();
        }
        iRDBDriver.formatDB();
        Assert.assertTrue((boolean)iRDBDriver.isDBFormatOK());
        Assert.assertTrue((boolean)dBConnection.isFormatOK());
        dBConnection.addProperty("test", "foobar");
        dBConnection.close();
        connection = DriverManager.getConnection(this.m_dbname, this.m_user, this.m_password);
        DBConnection dBConnection2 = new DBConnection(connection);
        IRDBDriver iRDBDriver2 = dBConnection2.getDriver();
        Assert.assertTrue((boolean)dBConnection2.isFormatOK());
        Assert.assertEquals((Object)dBConnection2.getProperty("driverClassname"), (Object)iRDBDriver2.getClass().getName());
        Assert.assertEquals((Object)this.m_layout, (Object)dBConnection2.getProperty("layoutType"));
        Assert.assertEquals((Object)this.m_database, (Object)dBConnection2.getProperty("databaseType"));
        Assert.assertEquals((Object)"foobar", (Object)dBConnection2.getProperty("test"));
        iRDBDriver2.close();
        iRDBDriver.cleanDB();
        iRDBDriver.close();
    }

    public static TestSuite suite(String string, String string2) {
        TestSuite testSuite = new TestSuite();
        testSuite.addTest((Test)new TestDBConnection("testBasicOperations", string, string2));
        return testSuite;
    }

    public static void main(String[] stringArray) {
        TestRunner.run((Test)TestDBConnection.suite("Generic", "Interbase"));
    }
}

