/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.xr;

import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.eclipse.persistence.mappings.foundation.AbstractTransformationMapping;
import org.eclipse.persistence.mappings.transformers.AttributeTransformer;
import org.eclipse.persistence.mappings.transformers.FieldTransformer;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLConstants;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.record.XMLRecord;
import org.eclipse.persistence.sessions.Record;
import org.eclipse.persistence.sessions.Session;

public class QNameTransformer
implements AttributeTransformer,
FieldTransformer {
    public static final Map<String, QName> SCHEMA_QNAMES = new HashMap<String, QName>(){
        {
            this.put("any", XMLConstants.ANY_QNAME);
            this.put("anySimpleType", XMLConstants.ANY_SIMPLE_TYPE_QNAME);
            this.put("base64Binary", XMLConstants.BASE_64_BINARY_QNAME);
            this.put("boolean", XMLConstants.BOOLEAN_QNAME);
            this.put("byte", XMLConstants.BYTE_QNAME);
            this.put("date", XMLConstants.DATE_QNAME);
            this.put("dateTime", XMLConstants.DATE_TIME_QNAME);
            this.put("decimal", XMLConstants.DECIMAL_QNAME);
            this.put("double", XMLConstants.DOUBLE_QNAME);
            this.put("float", XMLConstants.FLOAT_QNAME);
            this.put("hexBinary", XMLConstants.HEX_BINARY_QNAME);
            this.put("int", XMLConstants.INT_QNAME);
            this.put("integer", XMLConstants.INTEGER_QNAME);
            this.put("long", XMLConstants.LONG_QNAME);
            this.put("QName", XMLConstants.QNAME_QNAME);
            this.put("short", XMLConstants.SHORT_QNAME);
            this.put("string", XMLConstants.STRING_QNAME);
            this.put("time", XMLConstants.TIME_QNAME);
            this.put("unsignedByte", XMLConstants.UNSIGNED_BYTE_QNAME);
            this.put("unsignedInt", XMLConstants.UNSIGNED_INT_QNAME);
            this.put("unsignedShort", XMLConstants.UNSIGNED_SHORT_QNAME);
            this.put("swaRef", XMLConstants.SWA_REF_QNAME);
        }
    };
    private static final char COLON = ':';
    private static final String DEFAULT_NAMESPACE_PREFIX = "";
    AbstractTransformationMapping transformationMapping;
    private NamespaceResolver namespaceResolver;
    private String xPath;

    public QNameTransformer(String xPath) {
        this.xPath = xPath;
    }

    public void initialize(AbstractTransformationMapping mapping) {
        this.transformationMapping = mapping;
        this.namespaceResolver = ((XMLDescriptor)mapping.getDescriptor()).getNamespaceResolver();
    }

    public Object buildAttributeValue(Record record, Object object, Session session) {
        if (null == record) {
            return null;
        }
        String value = (String)record.get(this.xPath);
        if (null == value) {
            return null;
        }
        QName qName = null;
        int index = value.lastIndexOf(58);
        if (index > -1) {
            String prefix = value.substring(0, index);
            String localName = value.substring(index + 1);
            String namespaceURI = ((XMLRecord)record).resolveNamespacePrefix(prefix);
            if ("http://www.w3.org/2001/XMLSchema".equals(namespaceURI)) {
                qName = SCHEMA_QNAMES.get(localName);
                if (qName == null) {
                    qName = new QName("http://www.w3.org/2001/XMLSchema", localName, prefix == null ? DEFAULT_NAMESPACE_PREFIX : prefix);
                }
            } else {
                qName = new QName(namespaceURI == null ? DEFAULT_NAMESPACE_PREFIX : namespaceURI, localName, prefix == null ? DEFAULT_NAMESPACE_PREFIX : prefix);
            }
            return qName;
        }
        String namespaceURI = ((XMLRecord)record).resolveNamespacePrefix(DEFAULT_NAMESPACE_PREFIX);
        qName = new QName(namespaceURI, value);
        return qName;
    }

    public Object buildFieldValue(Object instance, String fieldName, Session session) {
        if (null == instance) {
            return null;
        }
        QName qName = (QName)this.transformationMapping.getAttributeValueFromObject(instance);
        if (null == qName.getNamespaceURI()) {
            return qName.getLocalPart();
        }
        String namespaceURI = qName.getNamespaceURI();
        String prefix = this.namespaceResolver.resolveNamespaceURI(namespaceURI);
        if (null == prefix) {
            return qName.getLocalPart();
        }
        return prefix + ':' + qName.getLocalPart();
    }
}

