/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.messageboards.pop;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.pop.MessageListener;
import com.liferay.portal.kernel.pop.MessageListenerException;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.PrefsPropsUtil;
import com.liferay.portal.kernel.util.StreamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.model.Company;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.security.permission.PermissionCheckerUtil;
import com.liferay.portal.service.CompanyLocalServiceUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.messageboards.model.MBCategory;
import com.liferay.portlet.messageboards.model.MBMessageConstants;
import com.liferay.portlet.messageboards.service.MBCategoryLocalServiceUtil;
import com.liferay.portlet.messageboards.service.MBMessageLocalServiceUtil;
import com.liferay.portlet.messageboards.service.MBMessageServiceUtil;
import com.liferay.portlet.messageboards.util.MBMailMessage;
import com.liferay.portlet.messageboards.util.MBUtil;
import java.io.InputStream;
import java.io.Serializable;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Part;
import org.apache.commons.lang.time.StopWatch;

public class MessageListenerImpl
implements MessageListener {
    private static Log _log = LogFactoryUtil.getLog(MessageListenerImpl.class);

    public boolean accept(String from, String recipient, Message message) {
        Company company;
        block11: {
            String pop3User;
            block10: {
                String messageIdString;
                block9: {
                    block8: {
                        try {
                            if (!this.isAutoReply(message)) break block8;
                            return false;
                        }
                        catch (Exception e2) {
                            if (_log.isErrorEnabled()) {
                                _log.error((Object)("Unable to process message: " + message), (Throwable)e2);
                            }
                            return false;
                        }
                    }
                    messageIdString = this.getMessageIdString(recipient, message);
                    if (messageIdString != null && messageIdString.startsWith("mb_message.", MBUtil.getMessageIdStringOffset())) break block9;
                    return false;
                }
                company = this.getCompany(messageIdString);
                long categoryId = MBUtil.getCategoryId(messageIdString);
                MBCategory category = MBCategoryLocalServiceUtil.getCategory((long)categoryId);
                if (category.getCompanyId() == company.getCompanyId() || category.isRoot()) break block10;
                return false;
            }
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Check to see if user " + from + " exists"));
            }
            if (!StringUtil.equalsIgnoreCase((String)from, (String)(pop3User = PrefsPropsUtil.getString((String)"mail.session.mail.pop3.user", (String)PropsValues.MAIL_SESSION_MAIL_POP3_USER)))) break block11;
            return false;
        }
        UserLocalServiceUtil.getUserByEmailAddress((long)company.getCompanyId(), (String)from);
        return true;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void deliver(String from, String recipient, Message message) throws MessageListenerException {
        block21: {
            inputStreamOVPs = null;
            try {
                try {
                    stopWatch = new StopWatch();
                    stopWatch.start();
                    if (MessageListenerImpl._log.isDebugEnabled()) {
                        MessageListenerImpl._log.debug((Object)("Deliver message from " + from + " to " + recipient));
                    }
                    messageIdString = this.getMessageIdString(recipient, message);
                    company = this.getCompany(messageIdString);
                    if (MessageListenerImpl._log.isDebugEnabled()) {
                        MessageListenerImpl._log.debug((Object)("Message id " + messageIdString));
                    }
                    parentMessageId = MBUtil.getMessageId(messageIdString);
                    if (MessageListenerImpl._log.isDebugEnabled()) {
                        MessageListenerImpl._log.debug((Object)("Parent message id " + parentMessageId));
                    }
                    parentMessage = null;
                    if (parentMessageId > 0L) {
                        parentMessage = MBMessageLocalServiceUtil.fetchMBMessage((long)parentMessageId);
                    }
                    if (MessageListenerImpl._log.isDebugEnabled()) {
                        MessageListenerImpl._log.debug((Object)("Parent message " + parentMessage));
                    }
                    groupId = 0L;
                    categoryId = MBUtil.getCategoryId(messageIdString);
                    category = MBCategoryLocalServiceUtil.fetchMBCategory((long)categoryId);
                    if (category == null) {
                        categoryId = 0L;
                        if (parentMessage != null) {
                            groupId = parentMessage.getGroupId();
                        }
                    } else {
                        groupId = category.getGroupId();
                    }
                    if (MessageListenerImpl._log.isDebugEnabled()) {
                        MessageListenerImpl._log.debug((Object)("Group id " + groupId));
                        MessageListenerImpl._log.debug((Object)("Category id " + categoryId));
                    }
                    user = UserLocalServiceUtil.getUserByEmailAddress((long)company.getCompanyId(), (String)from);
                    subject = null;
                    if (parentMessage != null) {
                        subject = MBUtil.getSubjectForEmail(parentMessage);
                    }
                    mbMailMessage = new MBMailMessage();
                    MBUtil.collectPartContent((Part)message, mbMailMessage);
                    inputStreamOVPs = mbMailMessage.getInputStreamOVPs();
                    PermissionCheckerUtil.setThreadValues(user);
                    serviceContext = new ServiceContext();
                    serviceContext.setAttribute("propagatePermissions", (Serializable)Boolean.TRUE);
                    serviceContext.setLayoutFullURL(PortalUtil.getLayoutFullURL((long)groupId, (String)"19", (boolean)StringUtil.equalsIgnoreCase((String)"https", (String)PropsValues.WEB_SERVER_PROTOCOL)));
                    serviceContext.setScopeGroupId(groupId);
                    if (parentMessage == null) {
                        MBMessageServiceUtil.addMessage((long)groupId, (long)categoryId, (String)subject, (String)mbMailMessage.getBody(), (String)MBMessageConstants.DEFAULT_FORMAT, inputStreamOVPs, (boolean)false, (double)0.0, (boolean)true, (ServiceContext)serviceContext);
                    } else {
                        MBMessageServiceUtil.addMessage((long)parentMessage.getMessageId(), (String)subject, (String)mbMailMessage.getBody(), (String)MBMessageConstants.DEFAULT_FORMAT, inputStreamOVPs, (boolean)false, (double)0.0, (boolean)true, (ServiceContext)serviceContext);
                    }
                    if (MessageListenerImpl._log.isDebugEnabled()) {
                        MessageListenerImpl._log.debug((Object)("Delivering message takes " + stopWatch.getTime() + " ms"));
                    }
                }
                catch (PrincipalException pe) {
                    if (MessageListenerImpl._log.isDebugEnabled()) {
                        MessageListenerImpl._log.debug((Object)("Prevented unauthorized post from " + from));
                    }
                    throw new MessageListenerException((Throwable)pe);
                }
                catch (Exception e) {
                    MessageListenerImpl._log.error((Object)e, (Throwable)e);
                    throw new MessageListenerException((Throwable)e);
                }
            }
            finally {
                if (inputStreamOVPs == null) break block21;
                ** for (inputStreamOVP : inputStreamOVPs)
            }
lbl-1000:
            // 1 sources

            {
                inputStream = (InputStream)inputStreamOVP.getValue();
                StreamUtil.cleanUp((InputStream)inputStream);
                continue;
            }
        }
        PermissionCheckerUtil.setThreadValues(null);
    }

    public String getId() {
        return MessageListenerImpl.class.getName();
    }

    protected Company getCompany(String messageIdString) throws Exception {
        int endPos;
        int pos = messageIdString.indexOf(64) + PropsValues.POP_SERVER_SUBDOMAIN.length() + 1;
        if (PropsValues.POP_SERVER_SUBDOMAIN.length() > 0) {
            ++pos;
        }
        if ((endPos = messageIdString.indexOf(62, pos)) == -1) {
            endPos = messageIdString.length();
        }
        String mx = messageIdString.substring(pos, endPos);
        return CompanyLocalServiceUtil.getCompanyByMx((String)mx);
    }

    protected String getMessageIdString(String recipient, Message message) throws Exception {
        if (PropsValues.POP_SERVER_SUBDOMAIN.length() > 0) {
            return recipient;
        }
        return MBUtil.getParentMessageIdString(message);
    }

    protected boolean isAutoReply(Message message) throws MessagingException {
        Object[] autoReply = message.getHeader("X-Autoreply");
        if (ArrayUtil.isNotEmpty((Object[])autoReply)) {
            return true;
        }
        Object[] autoReplyFrom = message.getHeader("X-Autoreply-From");
        if (ArrayUtil.isNotEmpty((Object[])autoReplyFrom)) {
            return true;
        }
        Object[] mailAutoReply = message.getHeader("X-Mail-Autoreply");
        return ArrayUtil.isNotEmpty((Object[])mailAutoReply);
    }
}

