/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.editor.fckeditor.receiver.impl;

import com.liferay.portal.editor.fckeditor.command.CommandArgument;
import com.liferay.portal.editor.fckeditor.receiver.impl.DocumentCommandReceiver;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.xuggler.XugglerUtil;
import com.liferay.portlet.documentlibrary.service.DLAppServiceUtil;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class BaseFileEntryCommandReceiver
extends DocumentCommandReceiver {
    @Override
    protected String fileUpload(CommandArgument commandArgument, String fileName, InputStream inputStream, String contentType, long size) {
        if (!XugglerUtil.isEnabled()) {
            return String.valueOf(this.getXugglerDisabledFileUploadReturnValue());
        }
        return super.fileUpload(commandArgument, fileName, inputStream, contentType, size);
    }

    @Override
    protected Element getFileElement(CommandArgument commandArgument, Element fileElement, FileEntry fileEntry) throws Exception {
        fileElement = super.getFileElement(commandArgument, fileElement, fileEntry);
        if (!this.hasFileEntryPreview(fileEntry.getFileVersion())) {
            fileElement.setAttribute("errorMessage", LanguageUtil.get((Locale)commandArgument.getLocale(), (String)this.getUnavaiablePreviewErrorMessage()));
        }
        return fileElement;
    }

    @Override
    protected List<Element> getFileElements(CommandArgument commandArgument, Document document, Folder folder) throws Exception {
        ArrayList<Element> fileElements = new ArrayList<Element>();
        List fileEntries = null;
        String[] fileEntryMimeTypes = this.getFileEntryMimeTypes();
        fileEntries = fileEntryMimeTypes != null ? DLAppServiceUtil.getFileEntries((long)folder.getRepositoryId(), (long)folder.getFolderId(), (String[])fileEntryMimeTypes) : DLAppServiceUtil.getFileEntries((long)folder.getRepositoryId(), (long)folder.getFolderId());
        for (FileEntry fileEntry : fileEntries) {
            Element fileElement = document.createElement("File");
            fileElement = this.getFileElement(commandArgument, fileElement, fileEntry);
            fileElements.add(fileElement);
        }
        return fileElements;
    }

    protected abstract String[] getFileEntryMimeTypes();

    protected abstract String getUnavaiablePreviewErrorMessage();

    protected abstract int getXugglerDisabledFileUploadReturnValue();

    protected abstract boolean hasFileEntryPreview(FileVersion var1);
}

