/*
 * Decompiled with CFR 0.152.
 */
package com.browseengine.bobo.sort;

import com.browseengine.bobo.sort.DocComparator;
import com.browseengine.bobo.sort.DocComparatorSource;
import java.io.IOException;
import java.io.Serializable;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.ScoreDoc;

public class ReverseDocComparatorSource
extends DocComparatorSource {
    private final DocComparatorSource _inner;

    public ReverseDocComparatorSource(DocComparatorSource inner) {
        this._inner = inner;
    }

    @Override
    public DocComparator getComparator(IndexReader reader, int docbase) throws IOException {
        return new ReverseDocComparator(this._inner.getComparator(reader, docbase));
    }

    public static class ReverseDocComparator
    extends DocComparator {
        private final DocComparator _comparator;

        public ReverseDocComparator(DocComparator comparator) {
            this._comparator = comparator;
        }

        @Override
        public int compare(ScoreDoc doc1, ScoreDoc doc2) {
            return -this._comparator.compare(doc1, doc2);
        }

        @Override
        public Comparable value(ScoreDoc doc) {
            return new ReverseComparable(this._comparator.value(doc));
        }

        public static class ReverseComparable
        implements Comparable,
        Serializable {
            private static final long serialVersionUID = 1L;
            final Comparable _inner;

            ReverseComparable(Comparable inner) {
                this._inner = inner;
            }

            public int compareTo(Object o) {
                if (o instanceof ReverseComparable) {
                    Comparable inner = ((ReverseComparable)o)._inner;
                    if (this._inner == null) {
                        if (inner == null) {
                            return 0;
                        }
                        return 1;
                    }
                    if (inner == null) {
                        return -1;
                    }
                    return -this._inner.compareTo(inner);
                }
                throw new IllegalStateException("expected instanace of " + ReverseComparable.class);
            }

            public String toString() {
                StringBuilder buf = new StringBuilder();
                buf.append("!").append(this._inner);
                return buf.toString();
            }
        }
    }
}

