/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler.ir.instructions;

import java.util.Map;
import org.jruby.RubyClass;
import org.jruby.compiler.ir.IRModule;
import org.jruby.compiler.ir.IRScope;
import org.jruby.compiler.ir.Operation;
import org.jruby.compiler.ir.instructions.GetInstr;
import org.jruby.compiler.ir.instructions.Instr;
import org.jruby.compiler.ir.operands.Label;
import org.jruby.compiler.ir.operands.MetaObject;
import org.jruby.compiler.ir.operands.Operand;
import org.jruby.compiler.ir.operands.Variable;
import org.jruby.compiler.ir.representations.InlinerInfo;
import org.jruby.interpreter.InterpreterContext;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchConstInstr
extends GetInstr {
    public SearchConstInstr(Variable dest, IRScope scope, String constName) {
        super(Operation.SEARCH_CONST, dest, MetaObject.create(scope), constName);
    }

    public SearchConstInstr(Variable dest, Operand scopeOrObj, String constName) {
        super(Operation.SEARCH_CONST, dest, scopeOrObj, constName);
    }

    @Override
    public Operand simplifyAndGetResult(Map<Operand, Operand> valueMap) {
        this.simplifyOperands(valueMap);
        if (!(this.getSource() instanceof MetaObject)) {
            return null;
        }
        IRScope s2 = ((MetaObject)this.getSource()).scope;
        return s2 instanceof IRModule ? ((IRModule)s2).getConstantValue(this.getName()) : null;
    }

    @Override
    public Instr cloneForInlining(InlinerInfo ii) {
        return new SearchConstInstr(ii.getRenamedVariable(this.result), this.getSource().cloneForInlining(ii), this.getName());
    }

    @Override
    public Label interpret(InterpreterContext interp, IRubyObject self) {
        Operand n = this.getSource();
        assert (n instanceof MetaObject) : "All sources should be a meta object";
        StaticScope staticScope = ((MetaObject)n).getScope().getStaticScope();
        RubyClass object = interp.getRuntime().getObject();
        this.getResult().store(interp, staticScope.getConstant(interp.getRuntime(), this.getName(), object));
        return null;
    }
}

