/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queryParser.standard;

import java.text.Collator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.DateTools;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.core.QueryNodeException;
import org.apache.lucene.queryParser.core.config.FieldConfig;
import org.apache.lucene.queryParser.core.config.QueryConfigHandler;
import org.apache.lucene.queryParser.core.nodes.QueryNode;
import org.apache.lucene.queryParser.core.parser.SyntaxParser;
import org.apache.lucene.queryParser.core.processors.QueryNodeProcessor;
import org.apache.lucene.queryParser.standard.StandardQueryParser;
import org.apache.lucene.queryParser.standard.builders.StandardQueryBuilder;
import org.apache.lucene.queryParser.standard.builders.StandardQueryTreeBuilder;
import org.apache.lucene.queryParser.standard.config.DefaultOperatorAttribute;
import org.apache.lucene.queryParser.standard.config.StandardQueryConfigHandler;
import org.apache.lucene.queryParser.standard.parser.StandardSyntaxParser;
import org.apache.lucene.queryParser.standard.processors.StandardQueryNodeProcessorPipeline;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.Query;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class QueryParserWrapper {
    public static final Operator AND_OPERATOR = Operator.AND;
    public static final Operator OR_OPERATOR = Operator.OR;
    private SyntaxParser syntaxParser = new StandardSyntaxParser();
    private StandardQueryConfigHandler config;
    private StandardQueryParser qpHelper;
    private QueryNodeProcessor processorPipeline;
    private StandardQueryBuilder builder = new StandardQueryTreeBuilder();
    private String defaultField;
    private Map<CharSequence, DateTools.Resolution> dateRes = new HashMap<CharSequence, DateTools.Resolution>();

    public static String escape(String s) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\\' || c == '+' || c == '-' || c == '!' || c == '(' || c == ')' || c == ':' || c == '^' || c == '[' || c == ']' || c == '\"' || c == '{' || c == '}' || c == '~' || c == '*' || c == '?' || c == '|' || c == '&') {
                sb.append('\\');
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public QueryParserWrapper(String defaultField, Analyzer analyzer) {
        this.defaultField = defaultField;
        this.qpHelper = new StandardQueryParser();
        this.config = (StandardQueryConfigHandler)this.qpHelper.getQueryConfigHandler();
        this.qpHelper.setAnalyzer(analyzer);
        this.processorPipeline = new StandardQueryNodeProcessorPipeline(this.config);
    }

    StandardQueryParser getQueryParserHelper() {
        return this.qpHelper;
    }

    public String getField() {
        return this.defaultField;
    }

    public Analyzer getAnalyzer() {
        if (this.config != null) {
            return this.config.get(StandardQueryConfigHandler.ConfigurationKeys.ANALYZER);
        }
        return null;
    }

    public void setQueryBuilder(StandardQueryBuilder builder) {
        this.builder = builder;
    }

    public void setQueryProcessor(QueryNodeProcessor processor) {
        this.processorPipeline = processor;
        this.processorPipeline.setQueryConfigHandler(this.config);
    }

    public void setQueryConfig(StandardQueryConfigHandler queryConfig) {
        this.config = queryConfig;
        if (this.processorPipeline != null) {
            this.processorPipeline.setQueryConfigHandler(this.config);
        }
    }

    public QueryConfigHandler getQueryConfigHandler() {
        return this.config;
    }

    public QueryNodeProcessor getQueryProcessor() {
        return this.processorPipeline;
    }

    public ParseException generateParseException() {
        return null;
    }

    public boolean getAllowLeadingWildcard() {
        if (this.config != null) {
            return this.config.get(StandardQueryConfigHandler.ConfigurationKeys.ALLOW_LEADING_WILDCARD, false);
        }
        return false;
    }

    public MultiTermQuery.RewriteMethod getMultiTermRewriteMethod() {
        if (this.config != null) {
            return this.config.get(StandardQueryConfigHandler.ConfigurationKeys.MULTI_TERM_REWRITE_METHOD, MultiTermQuery.CONSTANT_SCORE_AUTO_REWRITE_DEFAULT);
        }
        return MultiTermQuery.CONSTANT_SCORE_AUTO_REWRITE_DEFAULT;
    }

    public DateTools.Resolution getDateResolution(String fieldName) {
        FieldConfig fieldConfig;
        if (this.config != null && (fieldConfig = this.config.getFieldConfig(fieldName)) != null) {
            return fieldConfig.get(StandardQueryConfigHandler.ConfigurationKeys.DATE_RESOLUTION);
        }
        return null;
    }

    public boolean getEnablePositionIncrements() {
        if (this.config != null) {
            return this.config.get(StandardQueryConfigHandler.ConfigurationKeys.ENABLE_POSITION_INCREMENTS, false);
        }
        return false;
    }

    public float getFuzzyMinSim() {
        return 0.5f;
    }

    public int getFuzzyPrefixLength() {
        return 0;
    }

    public Locale getLocale() {
        if (this.config != null) {
            return this.config.get(StandardQueryConfigHandler.ConfigurationKeys.LOCALE, Locale.getDefault());
        }
        return Locale.getDefault();
    }

    public boolean getLowercaseExpandedTerms() {
        if (this.config != null) {
            return this.config.get(StandardQueryConfigHandler.ConfigurationKeys.LOWERCASE_EXPANDED_TERMS, true);
        }
        return true;
    }

    public int getPhraseSlop() {
        if (this.config != null) {
            return this.config.get(StandardQueryConfigHandler.ConfigurationKeys.PHRASE_SLOP, 0);
        }
        return 0;
    }

    public Collator getRangeCollator() {
        if (this.config != null) {
            return this.config.get(StandardQueryConfigHandler.ConfigurationKeys.RANGE_COLLATOR);
        }
        return null;
    }

    public boolean getUseOldRangeQuery() {
        return this.getMultiTermRewriteMethod() == MultiTermQuery.SCORING_BOOLEAN_QUERY_REWRITE;
    }

    public Query parse(String query) throws ParseException {
        try {
            QueryNode queryTree = this.syntaxParser.parse(query, this.getField());
            queryTree = this.processorPipeline.process(queryTree);
            return this.builder.build(queryTree);
        }
        catch (QueryNodeException e) {
            throw new ParseException("parse exception");
        }
    }

    public void setAllowLeadingWildcard(boolean allowLeadingWildcard) {
        this.qpHelper.setAllowLeadingWildcard(allowLeadingWildcard);
    }

    public void setMultiTermRewriteMethod(MultiTermQuery.RewriteMethod method) {
        this.qpHelper.setMultiTermRewriteMethod(method);
    }

    public void setDateResolution(DateTools.Resolution dateResolution) {
        this.qpHelper.setDateResolution(dateResolution);
    }

    public void setDateResolution(String fieldName, DateTools.Resolution dateResolution) {
        this.dateRes.put(fieldName, dateResolution);
        this.qpHelper.setDateResolution(this.dateRes);
    }

    public void setDefaultOperator(Operator op) {
        this.qpHelper.setDefaultOperator(OR_OPERATOR.equals((Object)op) ? DefaultOperatorAttribute.Operator.OR : DefaultOperatorAttribute.Operator.AND);
    }

    public Operator getDefaultOperator() {
        if (this.config != null) {
            return this.config.get(StandardQueryConfigHandler.ConfigurationKeys.DEFAULT_OPERATOR, StandardQueryConfigHandler.Operator.OR) == StandardQueryConfigHandler.Operator.AND ? AND_OPERATOR : OR_OPERATOR;
        }
        return OR_OPERATOR;
    }

    public void setEnablePositionIncrements(boolean enable) {
        this.qpHelper.setEnablePositionIncrements(enable);
    }

    public void setFuzzyMinSim(float fuzzyMinSim) {
    }

    public void setFuzzyPrefixLength(int fuzzyPrefixLength) {
    }

    public void setLocale(Locale locale) {
        this.qpHelper.setLocale(locale);
    }

    public void setLowercaseExpandedTerms(boolean lowercaseExpandedTerms) {
        this.qpHelper.setLowercaseExpandedTerms(lowercaseExpandedTerms);
    }

    public void setPhraseSlop(int phraseSlop) {
        this.qpHelper.setDefaultPhraseSlop(phraseSlop);
    }

    public void setRangeCollator(Collator rc) {
        this.qpHelper.setRangeCollator(rc);
    }

    public void setUseOldRangeQuery(boolean useOldRangeQuery) {
        if (useOldRangeQuery) {
            this.setMultiTermRewriteMethod(MultiTermQuery.SCORING_BOOLEAN_QUERY_REWRITE);
        } else {
            this.setMultiTermRewriteMethod(MultiTermQuery.CONSTANT_SCORE_AUTO_REWRITE_DEFAULT);
        }
    }

    protected Query getPrefixQuery(String field, String termStr) throws ParseException {
        throw new UnsupportedOperationException();
    }

    protected Query getWildcardQuery(String field, String termStr) throws ParseException {
        throw new UnsupportedOperationException();
    }

    protected Query getFuzzyQuery(String field, String termStr, float minSimilarity) throws ParseException {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    protected Query getFieldQuery(String field, String queryText) throws ParseException {
        return this.getFieldQuery(field, queryText, true);
    }

    protected Query getFieldQuery(String field, String queryText, boolean quoted) throws ParseException {
        throw new UnsupportedOperationException();
    }

    protected Query getBooleanQuery(List<BooleanClause> clauses, boolean disableCoord) throws ParseException {
        throw new UnsupportedOperationException();
    }

    protected Query getFieldQuery(String field, String queryText, int slop) throws ParseException {
        throw new UnsupportedOperationException();
    }

    protected Query getRangeQuery(String field, String part1, String part2, boolean inclusive) throws ParseException {
        throw new UnsupportedOperationException();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Operator {
        OR,
        AND;

    }
}

