/*
 * Decompiled with CFR 0.152.
 */
package org.jamwiki.parser.jflex;

import java.io.IOException;
import java.util.EnumSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.jamwiki.DataAccessException;
import org.jamwiki.parser.ParserException;
import org.jamwiki.parser.ParserInput;
import org.jamwiki.parser.ParserOutput;
import org.jamwiki.parser.jflex.JFlexLexer;
import org.jamwiki.parser.jflex.JFlexParserTag;
import org.jamwiki.parser.jflex.JFlexParserUtil;
import org.jamwiki.utils.ImageBorderEnum;
import org.jamwiki.utils.ImageHorizontalAlignmentEnum;
import org.jamwiki.utils.ImageMetadata;
import org.jamwiki.utils.ImageUtil;
import org.jamwiki.utils.ImageVerticalAlignmentEnum;
import org.jamwiki.utils.WikiLink;
import org.jamwiki.utils.WikiLogger;

public class ImageLinkTag
implements JFlexParserTag {
    private static final WikiLogger logger = WikiLogger.getLogger(ImageLinkTag.class.getName());
    private static Pattern IMAGE_SIZE_PATTERN = Pattern.compile("([0-9]+)?([ ]*x[ ]*([0-9]+))?[ ]*px", 2);
    private static Pattern IMAGE_ALT_PATTERN = Pattern.compile("alt[ ]*=[ ]*(.*)", 2);
    private static Pattern IMAGE_LINK_PATTERN = Pattern.compile("link[ ]*=[ ]*(.*)", 2);
    private static final int DEFAULT_THUMBNAIL_WIDTH = 220;

    public String parse(JFlexLexer lexer, String raw, Object ... args) throws ParserException {
        if (lexer.getMode() <= 6) {
            return lexer.parse(50, raw, new Object[0]);
        }
        WikiLink wikiLink = JFlexParserUtil.parseWikiLink(lexer.getParserInput(), lexer.getParserOutput(), raw);
        if (StringUtils.isBlank((String)wikiLink.getDestination())) {
            return raw;
        }
        if (wikiLink.getColon() || !wikiLink.getNamespace().getId().equals(6)) {
            return lexer.parse(50, raw, new Object[0]);
        }
        try {
            String result = this.parseImageLink(lexer.getParserInput(), lexer.getParserOutput(), lexer.getMode(), wikiLink);
            if (result.startsWith("<div") && lexer.peekTag().getTagType().equals("p")) {
                lexer.popTag("p");
                StringBuilder tagContent = lexer.peekTag().getTagContent();
                String trimmedTagContent = tagContent.toString().trim();
                if (tagContent.length() != trimmedTagContent.length()) {
                    tagContent.replace(0, tagContent.length() - 1, trimmedTagContent);
                }
                tagContent.append(result);
                lexer.pushTag("p", null);
                return "";
            }
            return result;
        }
        catch (DataAccessException e) {
            logger.error("Failure while parsing link " + raw, e);
            return "";
        }
        catch (ParserException e) {
            logger.error("Failure while parsing link " + raw, e);
            return "";
        }
    }

    private String parseImageLink(ParserInput parserInput, ParserOutput parserOutput, int mode, WikiLink wikiLink) throws DataAccessException, ParserException {
        String context = parserInput.getContext();
        ImageMetadata imageMetadata = this.parseImageParams(parserInput, parserOutput, mode, wikiLink.getText());
        if (imageMetadata.getAlt() == null) {
            imageMetadata.setAlt(wikiLink.getArticle());
        }
        try {
            String virtualWiki = wikiLink.getVirtualWiki() == null ? parserInput.getVirtualWiki() : wikiLink.getVirtualWiki().getName();
            return ImageUtil.buildImageLinkHtml(context, virtualWiki, wikiLink.getDestination(), imageMetadata, null, false);
        }
        catch (IOException e) {
            logger.warn("I/O Failure while parsing image link: " + e.getMessage(), e);
            return wikiLink.getDestination();
        }
    }

    private ImageMetadata parseImageParams(ParserInput parserInput, ParserOutput parserOutput, int mode, String paramText) throws ParserException {
        ImageMetadata imageMetadata = new ImageMetadata();
        if (StringUtils.isBlank((String)paramText)) {
            return imageMetadata;
        }
        String[] tokens = paramText.split("\\|");
        String caption = "";
        block0: for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            if (StringUtils.isBlank((String)token)) continue;
            token = token.trim();
            for (ImageBorderEnum border : EnumSet.allOf(ImageBorderEnum.class)) {
                if (!border.toString().equalsIgnoreCase(token)) continue;
                if (border == ImageBorderEnum.BORDER) {
                    imageMetadata.setBordered(true);
                    if (imageMetadata.getBorder() == ImageBorderEnum.FRAMELESS) continue block0;
                }
                imageMetadata.setBorder(border);
                continue block0;
            }
            for (ImageHorizontalAlignmentEnum horizontalAlignment : EnumSet.allOf(ImageHorizontalAlignmentEnum.class)) {
                if (!horizontalAlignment.toString().equalsIgnoreCase(token)) continue;
                imageMetadata.setHorizontalAlignment(horizontalAlignment);
                continue block0;
            }
            for (ImageVerticalAlignmentEnum verticalAlignment : EnumSet.allOf(ImageVerticalAlignmentEnum.class)) {
                if (!verticalAlignment.toString().equalsIgnoreCase(token)) continue;
                imageMetadata.setVerticalAlignment(verticalAlignment);
                continue block0;
            }
            Matcher matcher = IMAGE_SIZE_PATTERN.matcher(token);
            if (matcher.find()) {
                String maxHeight;
                String maxWidth = matcher.group(1);
                if (!StringUtils.isBlank((String)maxWidth)) {
                    imageMetadata.setMaxWidth(Integer.valueOf(maxWidth));
                }
                if (StringUtils.isBlank((String)(maxHeight = matcher.group(3)))) continue;
                imageMetadata.setMaxHeight(Integer.valueOf(maxHeight));
                continue;
            }
            matcher = IMAGE_ALT_PATTERN.matcher(token);
            if (matcher.find()) {
                imageMetadata.setAlt(matcher.group(1).trim());
                continue;
            }
            matcher = IMAGE_LINK_PATTERN.matcher(token);
            if (matcher.find()) {
                imageMetadata.setLink(matcher.group(1).trim());
                continue;
            }
            caption = caption + (StringUtils.isBlank((String)caption) ? token : "|" + token);
        }
        if (!StringUtils.isBlank((String)caption)) {
            int pos = (caption = JFlexParserUtil.parseFragment(parserInput, parserOutput, caption, mode)).indexOf(124);
            if (pos != -1) {
                caption = pos >= caption.length() - 1 ? " " : caption.substring(pos + 1);
            }
            imageMetadata.setCaption(caption);
        }
        if (imageMetadata.getVerticalAlignment() != ImageVerticalAlignmentEnum.NOT_SPECIFIED && (imageMetadata.getBorder() == ImageBorderEnum.THUMB || imageMetadata.getBorder() == ImageBorderEnum.FRAME)) {
            imageMetadata.setVerticalAlignment(ImageVerticalAlignmentEnum.NOT_SPECIFIED);
        }
        if (imageMetadata.getBorder() == ImageBorderEnum.THUMB || imageMetadata.getBorder() == ImageBorderEnum.FRAME) {
            imageMetadata.setLink(null);
        }
        if (imageMetadata.getBorder() != ImageBorderEnum.THUMB && imageMetadata.getBorder() != ImageBorderEnum.FRAME) {
            imageMetadata.setCaption(null);
        }
        if (imageMetadata.getBorder() == ImageBorderEnum.FRAME) {
            imageMetadata.setMaxHeight(-1);
            imageMetadata.setMaxWidth(-1);
        }
        if ((imageMetadata.getBorder() == ImageBorderEnum.THUMB || imageMetadata.getBorder() == ImageBorderEnum.FRAMELESS) && imageMetadata.getMaxWidth() <= 0) {
            imageMetadata.setMaxWidth(220);
        }
        if (imageMetadata.getBordered() && imageMetadata.getBorder() != ImageBorderEnum.BORDER && imageMetadata.getBorder() != ImageBorderEnum.FRAMELESS) {
            imageMetadata.setBordered(false);
        }
        return imageMetadata;
    }
}

