/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.lar.backgroundtask;

import com.liferay.portal.kernel.backgroundtask.BackgroundTaskResult;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.lar.ExportImportThreadLocal;
import com.liferay.portal.kernel.lar.MissingReferences;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.lar.backgroundtask.BaseStagingBackgroundTaskExecutor;
import com.liferay.portal.lar.backgroundtask.PortletStagingBackgroundTaskStatusMessageTranslator;
import com.liferay.portal.model.BackgroundTask;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import com.liferay.portal.spring.transaction.TransactionalCallableUtil;
import com.liferay.portal.util.PropsValues;
import java.io.File;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.Callable;

public class PortletStagingBackgroundTaskExecutor
extends BaseStagingBackgroundTaskExecutor {
    private static Log _log = LogFactoryUtil.getLog(PortletStagingBackgroundTaskExecutor.class);

    public PortletStagingBackgroundTaskExecutor() {
        this.setBackgroundTaskStatusMessageTranslator(new PortletStagingBackgroundTaskStatusMessageTranslator());
    }

    public BackgroundTaskResult execute(BackgroundTask backgroundTask) throws Exception {
        MissingReferences missingReferences = null;
        try {
            try {
                ExportImportThreadLocal.setPortletStagingInProcess((boolean)true);
                missingReferences = TransactionalCallableUtil.call(this.transactionAttribute, new PortletStagingCallable(backgroundTask));
            }
            catch (Throwable t) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)t, t);
                } else if (_log.isWarnEnabled()) {
                    _log.warn((Object)("Unable to publish portlet: " + t.getMessage()));
                }
                throw new SystemException(t);
            }
        }
        finally {
            ExportImportThreadLocal.setPortletStagingInProcess((boolean)false);
        }
        return this.processMissingReferences(backgroundTask, missingReferences);
    }

    private class PortletStagingCallable
    implements Callable<MissingReferences> {
        private BackgroundTask _backgroundTask;

        public PortletStagingCallable(BackgroundTask backgroundTask) {
            this._backgroundTask = backgroundTask;
        }

        @Override
        public MissingReferences call() throws Exception {
            Map taskContextMap = this._backgroundTask.getTaskContextMap();
            long userId = MapUtil.getLong((Map)taskContextMap, (String)"userId");
            long targetPlid = MapUtil.getLong((Map)taskContextMap, (String)"targetPlid");
            long targetGroupId = MapUtil.getLong((Map)taskContextMap, (String)"targetGroupId");
            String portletId = MapUtil.getString((Map)taskContextMap, (String)"portletId");
            Map parameterMap = (Map)taskContextMap.get("parameterMap");
            long sourcePlid = MapUtil.getLong((Map)taskContextMap, (String)"sourcePlid");
            long sourceGroupId = MapUtil.getLong((Map)taskContextMap, (String)"sourceGroupId");
            Date startDate = (Date)taskContextMap.get("startDate");
            Date endDate = (Date)taskContextMap.get("endDate");
            File larFile = null;
            MissingReferences missingReferences = null;
            try {
                larFile = LayoutLocalServiceUtil.exportPortletInfoAsFile((long)sourcePlid, (long)sourceGroupId, (String)portletId, (Map)parameterMap, (Date)startDate, (Date)endDate);
                this._backgroundTask = PortletStagingBackgroundTaskExecutor.this.markBackgroundTask(this._backgroundTask, "exported");
                missingReferences = LayoutLocalServiceUtil.validateImportPortletInfo((long)userId, (long)targetPlid, (long)targetGroupId, (String)portletId, (Map)parameterMap, (File)larFile);
                this._backgroundTask = PortletStagingBackgroundTaskExecutor.this.markBackgroundTask(this._backgroundTask, "validated");
                LayoutLocalServiceUtil.importPortletInfo((long)userId, (long)targetPlid, (long)targetGroupId, (String)portletId, (Map)parameterMap, (File)larFile);
            }
            catch (Exception e2) {
                if (PropsValues.STAGING_DELETE_TEMP_LAR_ON_FAILURE) {
                    FileUtil.delete(larFile);
                } else if (larFile != null && _log.isErrorEnabled()) {
                    _log.error((Object)("Kept temporary LAR file " + larFile.getAbsolutePath()));
                }
                throw e2;
            }
            if (PropsValues.STAGING_DELETE_TEMP_LAR_ON_SUCCESS) {
                FileUtil.delete((File)larFile);
            } else if (larFile != null && _log.isDebugEnabled()) {
                _log.debug((Object)("Kept temporary LAR file " + larFile.getAbsolutePath()));
            }
            return missingReferences;
        }
    }
}

