/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.net;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class SocketWrapper<E> {
    protected volatile E socket;
    protected volatile long lastAccess = System.currentTimeMillis();
    protected long timeout = -1L;
    protected boolean error = false;
    protected long lastRegistered = 0L;
    protected volatile int keepAliveLeft = 100;
    private boolean comet = false;
    protected boolean async = false;
    protected boolean keptAlive = false;
    private boolean upgraded = false;
    private boolean secure = false;
    private volatile boolean blockingStatus = true;
    private final Lock blockingStatusReadLock;
    private final ReentrantReadWriteLock.WriteLock blockingStatusWriteLock;
    private final Object writeThreadLock = new Object();

    public SocketWrapper(E socket) {
        this.socket = socket;
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        this.blockingStatusReadLock = lock.readLock();
        this.blockingStatusWriteLock = lock.writeLock();
    }

    public E getSocket() {
        return this.socket;
    }

    public boolean isComet() {
        return this.comet;
    }

    public void setComet(boolean comet) {
        this.comet = comet;
    }

    public boolean isAsync() {
        return this.async;
    }

    public void setAsync(boolean async) {
        this.async = async;
    }

    public boolean isUpgraded() {
        return this.upgraded;
    }

    public void setUpgraded(boolean upgraded) {
        this.upgraded = upgraded;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    public long getLastAccess() {
        return this.lastAccess;
    }

    public void access() {
        if (!this.isAsync()) {
            this.access(System.currentTimeMillis());
        }
    }

    public void access(long access) {
        this.lastAccess = access;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public boolean getError() {
        return this.error;
    }

    public void setError(boolean error) {
        this.error = error;
    }

    public void setKeepAliveLeft(int keepAliveLeft) {
        this.keepAliveLeft = keepAliveLeft;
    }

    public int decrementKeepAlive() {
        return --this.keepAliveLeft;
    }

    public boolean isKeptAlive() {
        return this.keptAlive;
    }

    public void setKeptAlive(boolean keptAlive) {
        this.keptAlive = keptAlive;
    }

    public boolean getBlockingStatus() {
        return this.blockingStatus;
    }

    public void setBlockingStatus(boolean blockingStatus) {
        this.blockingStatus = blockingStatus;
    }

    public Lock getBlockingStatusReadLock() {
        return this.blockingStatusReadLock;
    }

    public ReentrantReadWriteLock.WriteLock getBlockingStatusWriteLock() {
        return this.blockingStatusWriteLock;
    }

    public Object getWriteThreadLock() {
        return this.writeThreadLock;
    }

    public void reset(E socket, long timeout) {
        this.async = false;
        this.blockingStatus = true;
        this.comet = false;
        this.error = false;
        this.keepAliveLeft = 100;
        this.lastAccess = System.currentTimeMillis();
        this.socket = socket;
        this.timeout = timeout;
        this.upgraded = false;
    }

    public String toString() {
        return super.toString() + ":" + String.valueOf(this.socket);
    }
}

