/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.pacl.checker;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.pacl.permission.PortalMessageBusPermission;
import com.liferay.portal.security.pacl.checker.AuthorizationProperty;
import com.liferay.portal.security.pacl.checker.BaseChecker;
import java.security.Permission;
import java.util.Set;
import java.util.TreeSet;

public class PortalMessageBusChecker
extends BaseChecker {
    private static Log _log = LogFactoryUtil.getLog(PortalMessageBusChecker.class);
    private Set<String> _listenDestinationNames;
    private Set<String> _sendDestinationNames;

    @Override
    public void afterPropertiesSet() {
        this.initListenDestinationNames();
        this.initSendDestinationNames();
    }

    @Override
    public AuthorizationProperty generateAuthorizationProperty(Object ... arguments) {
        if (arguments == null || arguments.length != 1 || !(arguments[0] instanceof Permission)) {
            return null;
        }
        PortalMessageBusPermission portalMessageBusPermission = (PortalMessageBusPermission)arguments[0];
        String name = portalMessageBusPermission.getName();
        String key = null;
        if (name.equals("listen")) {
            key = "security-manager-message-bus-listen";
        } else if (name.equals("send")) {
            key = "security-manager-message-bus-send";
        } else {
            return null;
        }
        AuthorizationProperty authorizationProperty = new AuthorizationProperty();
        authorizationProperty.setKey(key);
        authorizationProperty.setValue(portalMessageBusPermission.getDestinationName());
        return authorizationProperty;
    }

    @Override
    public boolean implies(Permission permission) {
        PortalMessageBusPermission portalMessageBusPermission = (PortalMessageBusPermission)permission;
        String name = portalMessageBusPermission.getName();
        String destinationName = portalMessageBusPermission.getDestinationName();
        if (name.equals("listen")) {
            if (!this._listenDestinationNames.contains(destinationName)) {
                this.logSecurityException(_log, "Attempted to listen on destination " + destinationName);
                return false;
            }
        } else if (name.equals("send") && !this._sendDestinationNames.contains(destinationName)) {
            this.logSecurityException(_log, "Attempted to send to " + destinationName);
            return false;
        }
        return true;
    }

    protected void initListenDestinationNames() {
        this._listenDestinationNames = this.getPropertySet("security-manager-message-bus-listen");
        if (_log.isDebugEnabled()) {
            TreeSet<String> destinationNames = new TreeSet<String>(this._listenDestinationNames);
            for (String destinationName : destinationNames) {
                _log.debug((Object)("Allowing message listeners to listen on destination " + destinationName));
            }
        }
    }

    protected void initSendDestinationNames() {
        this._sendDestinationNames = this.getPropertySet("security-manager-message-bus-send");
        if (_log.isDebugEnabled()) {
            TreeSet<String> destinationNames = new TreeSet<String>(this._sendDestinationNames);
            for (String destinationName : destinationNames) {
                _log.debug((Object)("Allowing the message bus to send to destination " + destinationName));
            }
        }
    }
}

