/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.util.comparator;

import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.model.Layout;

public class LayoutPriorityComparator
extends OrderByComparator {
    public static final String ORDER_BY_ASC = "Layout.priority ASC";
    public static final String ORDER_BY_DESC = "Layout.priority DESC";
    public static final String[] ORDER_BY_FIELDS = new String[]{"priority"};
    private boolean _ascending;
    private Layout _layout;
    private boolean _lessThan;

    public LayoutPriorityComparator() {
        this(true);
    }

    public LayoutPriorityComparator(boolean ascending) {
        this._ascending = ascending;
    }

    public LayoutPriorityComparator(Layout layout, boolean lessThan) {
        this._layout = layout;
        this._lessThan = lessThan;
        this._ascending = true;
    }

    @Override
    public int compare(Object obj1, Object obj2) {
        int priority2;
        Layout layout1 = (Layout)obj1;
        Layout layout2 = (Layout)obj2;
        int value = 0;
        int priority1 = layout1.getPriority();
        if (priority1 > (priority2 = layout2.getPriority())) {
            value = 1;
        } else if (priority1 < priority2) {
            value = -1;
        } else if (this._layout != null) {
            if (this._layout.equals(layout1)) {
                value = this._lessThan ? 1 : -1;
            } else if (this._layout.equals(layout2)) {
                value = this._lessThan ? -1 : 1;
            }
        }
        if (this._ascending) {
            return value;
        }
        return -value;
    }

    @Override
    public String getOrderBy() {
        if (this._ascending) {
            return ORDER_BY_ASC;
        }
        return ORDER_BY_DESC;
    }

    @Override
    public String[] getOrderByFields() {
        return ORDER_BY_FIELDS;
    }

    @Override
    public boolean isAscending() {
        return this._ascending;
    }
}

